var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
// Reference paths for scriptedhost and diag hub. Make sure you also change the plugin.js and diagnosticshub.js referenced
// in the VsGraphicsDebuggerPkg.csproj if you change these below.
/// <reference path="../../../../../../out/typescriptapis/bptoob/inc/1.8/Plugin.d.ts" />
/// <reference path="../../../../../../out/typescriptapis/DiagnosticsHub/inc/TS-1.8.10/DiagnosticsHub.d.ts" />  
// 
// Copyright (C) Microsoft. All rights reserved.
//
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            "use strict";
            var ObservableViewModel = (function () {
                function ObservableViewModel() {
                    this._propertyChangedObservers = [];
                }
                ObservableViewModel.prototype.registerPropertyChanged = function (observer) {
                    this._propertyChangedObservers.push(observer);
                };
                ObservableViewModel.prototype.removePropertyChanged = function (observer) {
                    var index = this._propertyChangedObservers.indexOf(observer);
                    if (index >= 0) {
                        this._propertyChangedObservers = this._propertyChangedObservers.splice(index, 1);
                    }
                };
                ObservableViewModel.prototype.raisePropertyChanged = function (propertyName) {
                    /// <summary>
                    ///     NOTE: To be used only by the derived class. 
                    ///     Raise the propertyChanged event on the given property name.
                    /// </summary>
                    for (var i = 0; i < this._propertyChangedObservers.length; i++) {
                        this._propertyChangedObservers[i].onPropertyChanged(propertyName);
                    }
                };
                return ObservableViewModel;
            }());
            Controls.ObservableViewModel = ObservableViewModel;
            (function (NotifyCollectionChangedAction) {
                NotifyCollectionChangedAction[NotifyCollectionChangedAction["Add"] = 0] = "Add";
                NotifyCollectionChangedAction[NotifyCollectionChangedAction["Reset"] = 1] = "Reset";
                NotifyCollectionChangedAction[NotifyCollectionChangedAction["Replace"] = 2] = "Replace";
            })(Controls.NotifyCollectionChangedAction || (Controls.NotifyCollectionChangedAction = {}));
            var NotifyCollectionChangedAction = Controls.NotifyCollectionChangedAction;
            var NotifyCollectionChangedEventArgs = (function () {
                function NotifyCollectionChangedEventArgs(action, newItems, newStartingIndex, oldItems, oldStartingIndex) {
                    this._action = action;
                    this._newItems = newItems;
                    this._newStartingIndex = newStartingIndex;
                    this._oldItems = oldItems;
                    this._oldStartingIndex = oldStartingIndex;
                }
                Object.defineProperty(NotifyCollectionChangedEventArgs.prototype, "action", {
                    get: function () { return this._action; },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(NotifyCollectionChangedEventArgs.prototype, "newItems", {
                    get: function () { return this._newItems; },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(NotifyCollectionChangedEventArgs.prototype, "newStartingIndex", {
                    get: function () { return this._newStartingIndex; },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(NotifyCollectionChangedEventArgs.prototype, "oldItems", {
                    get: function () { return this._oldItems; },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(NotifyCollectionChangedEventArgs.prototype, "oldStartingIndex", {
                    get: function () { return this._oldStartingIndex; },
                    enumerable: true,
                    configurable: true
                });
                return NotifyCollectionChangedEventArgs;
            }());
            Controls.NotifyCollectionChangedEventArgs = NotifyCollectionChangedEventArgs;
            var ObservableCollection = (function () {
                function ObservableCollection() {
                    this._items = [];
                    this._collectionChangedObservers = [];
                }
                ObservableCollection.prototype.registerCollectionChanged = function (observer) {
                    this._collectionChangedObservers.push(observer);
                };
                ObservableCollection.prototype.removeCollectionChanged = function (observer) {
                    var index = this._collectionChangedObservers.indexOf(observer);
                    if (index >= 0) {
                        this._collectionChangedObservers = this._collectionChangedObservers.splice(index, 1);
                    }
                };
                ObservableCollection.prototype.add = function (item) {
                    this._items.push(item);
                    var args = new NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction.Add, [item], this._items.length - 1, [], 0);
                    this.onCollectionChanged(args);
                };
                ObservableCollection.prototype.replace = function (index, newItem) {
                    if (index >= 0 && index < this._items.length) {
                        var oldItem = this._items[index];
                        this._items[index] = newItem;
                        var args = new NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction.Replace, [newItem], index, [oldItem], index);
                        this.onCollectionChanged(args);
                    }
                };
                ObservableCollection.prototype.clear = function () {
                    var oldItems = this._items;
                    this._items = [];
                    var args = new NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction.Reset, [], 0, oldItems, oldItems.length - 1);
                    this.onCollectionChanged(args);
                };
                ObservableCollection.prototype.getItem = function (index) {
                    return this._items[index];
                };
                Object.defineProperty(ObservableCollection.prototype, "length", {
                    get: function () {
                        return this._items.length;
                    },
                    enumerable: true,
                    configurable: true
                });
                ObservableCollection.prototype.onCollectionChanged = function (eventArgs) {
                    for (var i = 0; i < this._collectionChangedObservers.length; i++) {
                        this._collectionChangedObservers[i].onCollectionChanged(eventArgs);
                    }
                };
                return ObservableCollection;
            }());
            Controls.ObservableCollection = ObservableCollection;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="..\Includes.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            "use strict";
            // Create a new control with the given root HTMLElement. If the root is not
            // provided, a default <div> root is used.
            var Control = (function () {
                function Control(root) {
                    this._rootElement = root;
                    if (typeof this._rootElement === "undefined") {
                        // We must have a root element to start with, default to a div. 
                        // This can change at any time by setting the property rootElement.
                        this._rootElement = document.createElement("div");
                        this._rootElement.style.width = this._rootElement.style.height = "100%";
                    }
                    else if (this._rootElement === null) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSPerf.1017"));
                    }
                }
                Control.prototype.appendChild = function (child) {
                    this._rootElement.appendChild(child.rootElement);
                    child.parent = this;
                };
                Control.prototype.removeChild = function (child) {
                    this._rootElement.removeChild(child.rootElement);
                    child.parent = null;
                };
                Object.defineProperty(Control.prototype, "rootElement", {
                    get: function () { return this._rootElement; },
                    set: function (newRoot) {
                        if (!newRoot) {
                            throw new Error(Microsoft.Plugin.Resources.getErrorString("JSPerf.1018"));
                        }
                        var oldRoot = this._rootElement;
                        this._rootElement = newRoot;
                        if (oldRoot && oldRoot.parentNode) {
                            oldRoot.parentNode.replaceChild(newRoot, oldRoot);
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(Control.prototype, "parent", {
                    get: function () { return this._parent; },
                    set: function (newParent) {
                        if (this._parent !== newParent) {
                            this._parent = newParent;
                            if (this._parent && !this._parent.rootElement.contains(this._rootElement)) {
                                this._parent.appendChild(this);
                            }
                            this.onParentChanged();
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                // overridable
                Control.prototype.onParentChanged = function () {
                };
                return Control;
            }());
            Controls.Control = Control;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="control.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            "use strict";
            // This TemplateControl initializes the control from a template.
            var TemplateControl = (function (_super) {
                __extends(TemplateControl, _super);
                function TemplateControl(templateName) {
                    _super.call(this);
                    // Assign the id postfix to use when fixing id's in the template
                    this._idPostfix = TemplateControl._globalIdPostfix++;
                    if (templateName) {
                        this.setTemplateFromName(templateName);
                    }
                }
                TemplateControl.prototype.setTemplateFromName = function (templateName) {
                    var root = this.getTemplateElementCopy(templateName);
                    this.adjustElementIds(root);
                    this.rootElement = root;
                };
                TemplateControl.prototype.setTemplateFromHTML = function (htmlContent) {
                    var root = this.getTemplateElementFromHTML(htmlContent);
                    this.adjustElementIds(root);
                    this.rootElement = root;
                };
                TemplateControl.prototype.findElement = function (id) {
                    var fullId = id + this._idPostfix;
                    return this.forAllSelfAndDescendants(this.rootElement, function (elem) {
                        if (elem.id && elem.id === fullId) {
                            return false;
                        }
                        return true;
                    });
                };
                TemplateControl.prototype.findElementsByClassName = function (className) {
                    var elements = [];
                    this.forAllSelfAndDescendants(this.rootElement, function (elem) {
                        if (elem.classList && elem.classList.contains(className)) {
                            elements.push(elem);
                        }
                        return true;
                    });
                    return elements;
                };
                TemplateControl.prototype.getTemplateElementCopy = function (templateName) {
                    var templateElement = document.getElementById(templateName);
                    if (!templateElement) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSPerf.1023"));
                    }
                    if (templateElement.tagName.toLowerCase() !== "script") {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("JSPerf.1024"));
                    }
                    return this.getTemplateElementFromHTML(templateElement.innerHTML);
                };
                TemplateControl.prototype.getTemplateElementFromHTML = function (htmlContent) {
                    var root = this.getTemplateRootElement();
                    root.innerHTML = htmlContent;
                    // If the template contains one child, use that as the root instead
                    if (root.childElementCount === 1) {
                        root = root.firstElementChild;
                    }
                    return root;
                };
                TemplateControl.prototype.getTemplateRootElement = function () {
                    var div = document.createElement("div");
                    div.style.width = div.style.height = "100%";
                    return div;
                };
                TemplateControl.prototype.adjustElementIds = function (root) {
                    // Postfix all id's with the new id
                    var idPostfix = this._idPostfix;
                    this.forAllSelfAndDescendants(root, function (elem) {
                        if (elem.id) {
                            elem.id = elem.id + idPostfix;
                        }
                        return true;
                    });
                };
                TemplateControl.prototype.forAllSelfAndDescendants = function (root, func) {
                    // <summary>Executes the given delegate on all the node and all its decendant elements. The callback function needs to return false to break the loop.</summary>
                    // <returns>The element at which the loop exit at, or null otherwise.</returns>
                    var brokeAtElement = null;
                    if (!func(root)) {
                        brokeAtElement = root;
                    }
                    else {
                        if (root.children) {
                            var children = root.children;
                            var childrenLength = children.length;
                            for (var i = 0; i < childrenLength; i++) {
                                brokeAtElement = this.forAllSelfAndDescendants(children[i], func);
                                if (brokeAtElement) {
                                    break;
                                }
                            }
                        }
                    }
                    return brokeAtElement;
                };
                TemplateControl._globalIdPostfix = 1;
                return TemplateControl;
            }(Controls.Control));
            Controls.TemplateControl = TemplateControl;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        "use strict";
        var Enum = (function () {
            function Enum() {
            }
            Enum.GetName = function (enumType, value) {
                var result;
                if (enumType) {
                    for (var enumKey in enumType) {
                        if (enumType.hasOwnProperty(enumKey)) {
                            var enumValue = enumType[enumKey];
                            if (enumValue === value) {
                                result = enumKey;
                                break;
                            }
                        }
                    }
                }
                if (!result) {
                    result = value.toString();
                }
                return result;
            };
            Enum.Parse = function (enumType, name, ignoreCase) {
                if (ignoreCase === void 0) { ignoreCase = true; }
                var result;
                if (enumType) {
                    if (ignoreCase) {
                        name = name.toLowerCase();
                    }
                    for (var enumKey in enumType) {
                        if (enumType.hasOwnProperty(enumKey)) {
                            var compareAginst = enumKey.toString();
                            if (ignoreCase) {
                                compareAginst = compareAginst.toLowerCase();
                            }
                            if (name === compareAginst) {
                                result = enumType[enumKey];
                                break;
                            }
                        }
                    }
                }
                return result;
            };
            Enum.GetValues = function (enumType) {
                var result = [];
                if (enumType) {
                    for (var enumKey in enumType) {
                        if (enumType.hasOwnProperty(enumKey)) {
                            var enumValue = enumType[enumKey];
                            if (typeof enumValue === "number") {
                                result.push(enumValue);
                            }
                        }
                    }
                }
                return result;
            };
            return Enum;
        }());
        Common.Enum = Enum;
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        "use strict";
        var ErrorFormatter = (function () {
            function ErrorFormatter() {
            }
            ErrorFormatter.format = function (error) {
                // Depending on the source, the error object will be different
                return (error.message || error.description);
            };
            return ErrorFormatter;
        }());
        Common.ErrorFormatter = ErrorFormatter;
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../Includes.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        "use strict";
        var FormattingHelpers = (function () {
            function FormattingHelpers() {
            }
            FormattingHelpers.getPrettyPrintSize = function (bytes, includeSign) {
                if (includeSign === void 0) { includeSign = false; }
                var size = 0;
                var unitAbbreviation;
                if (Math.abs(bytes) > (1024 * 1024 * 1024)) {
                    size = bytes / (1024 * 1024 * 1024);
                    unitAbbreviation = Microsoft.Plugin.Resources.getString("GigabyteUnits");
                }
                else if (Math.abs(bytes) > (1024 * 1024)) {
                    size = bytes / (1024 * 1024);
                    unitAbbreviation = Microsoft.Plugin.Resources.getString("MegabyteUnits");
                }
                else if (Math.abs(bytes) > 1024) {
                    size = bytes / 1024;
                    unitAbbreviation = Microsoft.Plugin.Resources.getString("KilobyteUnits");
                }
                else {
                    size = bytes;
                    unitAbbreviation = Microsoft.Plugin.Resources.getString("ByteUnits");
                }
                return FormattingHelpers.getDecimalLocaleString(parseFloat(size.toFixed(2)), true, includeSign) + " " + unitAbbreviation;
            };
            FormattingHelpers.zeroPad = function (stringToPad, newLength, padLeft) {
                for (var i = stringToPad.length; i < newLength; i++) {
                    stringToPad = (padLeft ? ("0" + stringToPad) : (stringToPad + "0"));
                }
                return stringToPad;
            };
            FormattingHelpers.forceNumberSign = function (numberToConvert, positive) {
                var nf = Microsoft.Plugin.Culture.NumberFormat;
                if (!nf) {
                    nf = {
                        positiveSign: "+",
                        negativeSign: "-",
                    };
                }
                if (positive === true) {
                    return nf.positiveSign + numberToConvert;
                }
                return nf.negativeSign + numberToConvert;
            };
            // Trims a long string to the format {1-17}...{last 17} characters - mimicking Visual Studio tabs.
            FormattingHelpers.trimLongString = function (stringToConvert) {
                var substitutedString = stringToConvert;
                var maxStringLength = 38;
                if (stringToConvert.length > maxStringLength) {
                    var substrLength = (maxStringLength / 2) - 2;
                    substitutedString = stringToConvert.substr(0, substrLength) + "\u2026" + stringToConvert.substr(-(substrLength));
                }
                return substitutedString;
            };
            FormattingHelpers.getDecimalLocaleString = function (numberToConvert, includeGroupSeparators, includeSign) {
                if (includeSign === void 0) { includeSign = false; }
                var wasPositive = true;
                if (numberToConvert < 0) {
                    wasPositive = false;
                    numberToConvert = numberToConvert * -1;
                }
                var numberString = numberToConvert.toString();
                // Get any exponent
                var split = numberString.split(/e/i);
                numberString = split[0];
                var exponent = (split.length > 1 ? parseInt(split[1], 10) : 0);
                // Get any decimal place
                split = numberString.split('.');
                numberString = split[0];
                // Get whole value
                var right = split.length > 1 ? split[1] : "";
                if (exponent > 0) {
                    right = FormattingHelpers.zeroPad(right, exponent, false);
                    numberString += right.slice(0, exponent);
                    right = right.substr(exponent);
                }
                else if (exponent < 0) {
                    exponent = -exponent;
                    numberString = FormattingHelpers.zeroPad(numberString, exponent + 1, true);
                    right = numberString.slice(-exponent, numberString.length) + right;
                    numberString = numberString.slice(0, -exponent);
                }
                // Number format
                var nf = Microsoft.Plugin.Culture.NumberFormat;
                if (!nf) {
                    nf = { numberDecimalSeparator: ".", numberGroupSizes: [3], numberGroupSeparator: "," };
                }
                if (right.length > 0) {
                    right = nf.numberDecimalSeparator + right;
                }
                // Grouping (e.g. 10,000)
                if (includeGroupSeparators === true) {
                    var groupSizes = nf.numberGroupSizes, sep = nf.numberGroupSeparator, curSize = groupSizes[0], curGroupIndex = 1, stringIndex = numberString.length - 1, ret = "";
                    while (stringIndex >= 0) {
                        if (curSize === 0 || curSize > stringIndex) {
                            if (ret.length > 0) {
                                numberString = numberString.slice(0, stringIndex + 1) + sep + ret + right;
                            }
                            else {
                                numberString = numberString.slice(0, stringIndex + 1) + right;
                            }
                            if (includeSign) {
                                numberString = FormattingHelpers.forceNumberSign(numberString, wasPositive);
                            }
                            return numberString;
                        }
                        if (ret.length > 0) {
                            ret = numberString.slice(stringIndex - curSize + 1, stringIndex + 1) + sep + ret;
                        }
                        else {
                            ret = numberString.slice(stringIndex - curSize + 1, stringIndex + 1);
                        }
                        stringIndex -= curSize;
                        if (curGroupIndex < groupSizes.length) {
                            curSize = groupSizes[curGroupIndex];
                            curGroupIndex++;
                        }
                    }
                    numberString = numberString.slice(0, stringIndex + 1) + sep + ret + right;
                    if (includeSign) {
                        numberString = FormattingHelpers.forceNumberSign(numberString, wasPositive);
                    }
                    return numberString;
                }
                else {
                    numberString = numberString + right;
                    if (includeSign) {
                        numberString = FormattingHelpers.forceNumberSign(numberString, wasPositive);
                    }
                    return numberString;
                }
            };
            FormattingHelpers.forceNonBreakingSpaces = function (stringToConvert) {
                var substitutedString = stringToConvert.replace(/\s/g, function (match, pos, originalText) {
                    return "\u00a0";
                });
                return substitutedString;
            };
            FormattingHelpers.getNativeDigitLocaleString = function (stringToConvert) {
                var nf = Microsoft.Plugin.Culture.NumberFormat;
                if (!nf) {
                    nf = {
                        nativeDigits: ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
                    };
                }
                var substitutedString = stringToConvert.replace(/\d/g, function (match, pos, originalText) {
                    return (nf.nativeDigits[parseInt(match)]);
                });
                return substitutedString;
            };
            // Simple string formatter, replacing {0},{1}... tokens with passed strings
            FormattingHelpers.stringFormat = function (formatString, values) {
                var formattedString = formatString;
                for (var i = 0; i < values.length; i++) {
                    var formatToken = "{" + i + '}';
                    formattedString = formattedString.replace(formatToken, values[i]);
                }
                return formattedString;
            };
            return FormattingHelpers;
        }());
        Common.FormattingHelpers = FormattingHelpers;
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="IFrame.d.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var Frame = (function () {
            function Frame(id) {
                this._id = id;
            }
            Object.defineProperty(Frame.prototype, "id", {
                get: function () {
                    return this._id;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Frame.prototype, "timestamp", {
                get: function () {
                    return this._timestamp;
                },
                set: function (time) {
                    this._timestamp = time;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Frame.prototype, "startTime", {
                get: function () {
                    return this._startTime;
                },
                set: function (time) {
                    this._startTime = time;
                    if (time > this._endTime) {
                        this._endTime = time;
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Frame.prototype, "endTime", {
                get: function () {
                    return this._endTime;
                },
                set: function (time) {
                    this._endTime = time;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Frame.prototype, "screenshotFile", {
                get: function () {
                    return this._screenshotFile;
                },
                set: function (filename) {
                    this._screenshotFile = filename;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Frame.prototype, "hasScreenshot", {
                get: function () {
                    return this._hasScreenshot;
                },
                enumerable: true,
                configurable: true
            });
            return Frame;
        }());
        Capture.Frame = Frame;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="../../Common/Controls/templateControl.ts" />
/// <reference path="../../Common/Util/formattingHelpers.ts" />
/// <reference path="../../Common/controls/componentModel.ts" />
/// <reference path="Frame.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var FrameTileViewModel = (function (_super) {
            __extends(FrameTileViewModel, _super);
            function FrameTileViewModel(summary) {
                _super.call(this);
                this._summary = summary;
            }
            Object.defineProperty(FrameTileViewModel.prototype, "summaryData", {
                get: function () {
                    return this._summary;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(FrameTileViewModel.prototype, "timeTaken", {
                get: function () {
                    var date = new Date(this._summary.timestamp);
                    return "(" + date.toLocaleTimeString() + ")";
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(FrameTileViewModel.prototype, "enabled", {
                get: function () { return this._enabled; },
                set: function (v) {
                    this._enabled = v;
                    this.raisePropertyChanged("enabled");
                },
                enumerable: true,
                configurable: true
            });
            return FrameTileViewModel;
        }(VsGraphics.Common.Controls.ObservableViewModel));
        Capture.FrameTileViewModel = FrameTileViewModel;
        var FrameTileView = (function (_super) {
            __extends(FrameTileView, _super);
            function FrameTileView(controller, model) {
                _super.call(this, "FrameTileTemplate");
                this._controller = controller;
                this._model = model;
                this._frameTile = this.findElement("frameTile");
                this._onDetailsClickHandler = this.onDetailsClick.bind(this);
                this._model.registerPropertyChanged(this);
                this._tileHeader = this.findElement("frameTileHeader");
                this.findElement("seeFrameDetailsButton").innerText = Microsoft.Plugin.Resources.getString("FrameNumberFormat", this._model.summaryData.id);
                var frameImageNotAvailable = this.findElement("frameImageNotAvailable");
                if (this._model.summaryData.screenshotFile && this._model.summaryData.hasScreenshot) {
                    var imgHolder = this.findElement("frameTileImage");
                    imgHolder.addEventListener("dblclick", this._onDetailsClickHandler);
                    imgHolder.src = this._model.summaryData.screenshotFile;
                    frameImageNotAvailable.hidden = true;
                }
                else {
                    frameImageNotAvailable.hidden = false;
                    frameImageNotAvailable.innerText = Microsoft.Plugin.Resources.getString("ScreenshotNotAvailable");
                    frameImageNotAvailable.addEventListener("dblclick", this._onDetailsClickHandler);
                }
                this.findElement("frameTakenDate").innerText = this._model.timeTaken;
                this._detailsButton = this.findElement("seeFrameDetailsButton");
                this._detailsButton.addEventListener("click", this._onDetailsClickHandler);
                this._detailsButton.addEventListener("keypress", this._onDetailsClickHandler);
                this._detailsDisabled = this.findElement("frameTileTitleDisabled");
                if (this._detailsDisabled != null)
                    this._detailsDisabled.innerText = this._detailsButton.innerText;
            }
            FrameTileView.prototype.onPropertyChanged = function (propertyName) {
                switch (propertyName) {
                    case "enabled":
                        this.updateLinkState();
                        break;
                }
            };
            FrameTileView.prototype.setFocus = function () {
                this._tileHeader.focus();
            };
            FrameTileView.prototype.onDetailsClick = function (e) {
                this._controller.selectFrame(this._model.summaryData.id);
            };
            FrameTileView.prototype.updateLinkState = function () {
                this._detailsButton.disabled = !this._model.enabled;
                var remove;
                var add;
                remove = this._detailsButton.disabled ? this._detailsDisabled : this._detailsButton;
                add = this._detailsButton.disabled ? this._detailsButton : this._detailsDisabled;
                // Show/Hide the plain text instead of the html link
                if (remove != null) {
                    remove.classList.remove("frameTileHidden");
                }
                if (add != null) {
                    add.classList.add("frameTileHidden");
                }
            };
            return FrameTileView;
        }(VsGraphics.Common.Controls.TemplateControl));
        Capture.FrameTileView = FrameTileView;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../common/controls/componentModel.ts" />
/// <reference path="../../common/controls/templateControl.ts" />
/// <reference path="IView.d.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var CaptureFrameTask = (function () {
            function CaptureFrameTask(controller, session) {
                this._controller = controller;
                this._session = session;
                this._startedCapture = false;
                this._canCapture = false;
                this._session.addFrameProcessingEventListener(this.onFrameResult.bind(this));
            }
            CaptureFrameTask.prototype.start = function () {
                var _this = this;
                return new Microsoft.Plugin.Promise(function (completed, error) {
                    if (_this._canCapture) {
                        if (!_this.captureFrameInternal()) {
                            if (error) {
                                error(new Error("Frame Not Currently Enabled"));
                            }
                        }
                        else {
                            _this._frameCompleted = completed;
                            _this._frameError = error;
                        }
                    }
                });
            };
            CaptureFrameTask.prototype.setReady = function () {
                this._canCapture = true;
                this._controller.appIsReadyToCapture();
            };
            CaptureFrameTask.prototype.isCompleted = function (message) {
                if (message) {
                    var obj = JSON.parse(message);
                    if (obj.eventName) {
                        if (obj.eventName === "frameData") {
                            if (this._controller.isViewBusy) {
                            }
                        }
                    }
                    else {
                        if (this._controller.isViewBusy) {
                            if (obj.frameResults) {
                                this.onFrameResult(obj);
                            }
                            else {
                                var response = obj;
                            }
                            return true;
                        }
                    }
                }
                return false;
            };
            CaptureFrameTask.prototype.captureFrameInternal = function () {
                if (this._controller.isViewBusy) {
                    return false;
                }
                this._startedCapture = true;
                this._controller.isCapturingFrame = true;
                this._session.startCapture();
                return true;
            };
            CaptureFrameTask.prototype.onFrameResult = function (result) {
                var _this = this;
                if (!result) {
                    throw new Error("<move to resources>: frameAsync ended with no response");
                }
                if (result.succeeded) {
                    result.frames.forEach(function (frame) {
                        _this._controller.addFrame(frame);
                        _this._controller.pendingCaptureCount = _this._controller.pendingCaptureCount == 0 ? 0 : _this._controller.pendingCaptureCount - 1;
                    });
                }
                // Turn off the progress bar
                if (this._controller.pendingCaptureCount == 0) {
                    this._controller.isCapturingFrame = false;
                    if (this._startedCapture) {
                        this._startedCapture = false;
                        this._controller.completedTask(this);
                    }
                }
            };
            return CaptureFrameTask;
        }());
        Capture.CaptureFrameTask = CaptureFrameTask;
        var GetFramesTask = (function () {
            function GetFramesTask(controller, session) {
                this._controller = controller;
                this._session = session;
                this._session.addFrameProcessingEventListener(this.onFrameResult.bind(this));
            }
            GetFramesTask.prototype.start = function () {
                var _this = this;
                return new Microsoft.Plugin.Promise(function (completed, error) {
                    if (!_this.getFramesInternal()) {
                        if (error) {
                            error(new Error("Frame Not Currently Enabled"));
                        }
                    }
                    else {
                        _this._frameCompleted = completed;
                        _this._frameError = error;
                    }
                });
            };
            GetFramesTask.prototype.isCompleted = function (message) {
                if (message) {
                    var obj = JSON.parse(message);
                    if (obj.eventName) {
                        if (obj.eventName === "frameData") {
                            if (this._controller.isViewBusy) {
                            }
                        }
                    }
                    else {
                        if (this._controller.isViewBusy) {
                            if (obj.frameResults) {
                                this.onFrameResult(obj);
                            }
                            else {
                                var response = obj;
                            }
                            return true;
                        }
                    }
                }
                return false;
            };
            GetFramesTask.prototype.getFramesInternal = function () {
                if (this._controller.isViewBusy) {
                    return false;
                }
                this._session.getFrames();
                return true;
            };
            GetFramesTask.prototype.onFrameResult = function (result) {
                var _this = this;
                if (!result) {
                    throw new Error("<move to resources>: frameAsync ended with no response");
                }
                if (result.succeeded) {
                    result.frames.forEach(function (frame) {
                        _this._controller.addFrame(frame);
                    });
                }
            };
            return GetFramesTask;
        }());
        Capture.GetFramesTask = GetFramesTask;
        var SelectFrameTask = (function () {
            function SelectFrameTask(controller, session) {
                this._frame = 0;
                this._controller = controller;
                this._session = session;
            }
            Object.defineProperty(SelectFrameTask.prototype, "frame", {
                get: function () {
                    return this._frame;
                },
                set: function (theFrame) {
                    this._frame = theFrame;
                },
                enumerable: true,
                configurable: true
            });
            SelectFrameTask.prototype.start = function () {
                var _this = this;
                return new Microsoft.Plugin.Promise(function (completed, error) {
                    _this.selectFrameInternal();
                    _this._controller.completedTask(_this);
                });
            };
            SelectFrameTask.prototype.isCompleted = function (message) {
                if (message) {
                    var obj = JSON.parse(message);
                    if (obj.eventName) {
                        if (obj.eventName === "frameData") {
                            if (this._controller.isViewBusy) {
                            }
                        }
                    }
                    else {
                        if (this._controller.isViewBusy) {
                            return true;
                        }
                    }
                }
                return false;
            };
            SelectFrameTask.prototype.selectFrameInternal = function () {
                if (this._controller.isViewBusy) {
                    return false;
                }
                this._session.selectFrame(this._frame);
                return true;
            };
            return SelectFrameTask;
        }());
        Capture.SelectFrameTask = SelectFrameTask;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="../../common/controls/componentModel.ts" />
/// <reference path="../../common/controls/templateControl.ts" />
/// <reference path="../../common/util/EnumHelper.ts" />
/// <reference path="../../common/util/errorFormatter.ts" />
/// <reference path="frameTileView.ts" />
/// <reference path="ViewTasks.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var ViewBaseController = (function () {
            function ViewBaseController(session, initializeView) {
                var _this = this;
                if (initializeView === void 0) { initializeView = true; }
                this._screenshotHeight = 150;
                this._screenshotKeepAspectRatio = true;
                this._screenshotWidth = 200;
                // This is the guid of GpuProfilingAgent
                this._agentGuid = new Microsoft.VisualStudio.DiagnosticsHub.Guid("9e5de5fb-d655-401a-86a8-5764c252744d");
                this._activeCollectionAgentTasks = [];
                this.model = new ViewModel();
                // Note: it's up to derived classes to initialize the view.
                var receiver = function (args) {
                    _this.onMessageReceived(args);
                };
                this._standardCollector = Microsoft.VisualStudio.DiagnosticsHub.Collectors.getStandardTransportService();
                if (this._standardCollector) {
                    this._standardCollector.addMessageListener(this._agentGuid, receiver);
                }
                this._selectFrameTask = new Capture.SelectFrameTask(this, session);
            }
            Object.defineProperty(ViewBaseController.prototype, "isCollectionAgentTaskActive", {
                get: function () {
                    return this._activeCollectionAgentTasks.length > 0;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewBaseController.prototype, "isViewBusy", {
                get: function () {
                    return this.model.isViewBusy;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewBaseController.prototype, "isCapturingFrame", {
                get: function () {
                    return this.model.isCapturingFrame;
                },
                set: function (val) {
                    this.model.isCapturingFrame = val;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewBaseController.prototype, "pendingCaptureCount", {
                get: function () {
                    return this.model.pendingCaptureCount;
                },
                set: function (val) {
                    this.model.pendingCaptureCount = val;
                },
                enumerable: true,
                configurable: true
            });
            ViewBaseController.prototype.addTask = function (task) {
                this._activeCollectionAgentTasks.push(task);
            };
            ViewBaseController.prototype.selectFrame = function (frame) {
                this._activeCollectionAgentTasks.push(this._selectFrameTask);
                this._selectFrameTask.frame = frame;
                return this._selectFrameTask.start();
            };
            ViewBaseController.prototype.addFrame = function (frame) {
                ViewBaseController._nextIdentifier++;
                this.model.frameSummaryCollection.add(frame);
            };
            ViewBaseController.prototype.reset = function () {
                ViewBaseController._nextIdentifier = 1;
                this.model.frameSummaryCollection.clear();
                Capture.s_ViewHost.onIdle();
            };
            ViewBaseController.prototype.sendStringToCollectionAgent = function (request) {
                return this._standardCollector.sendStringToCollectionAgent(this._agentGuid.toString(), request);
            };
            ViewBaseController.prototype.downloadFile = function (targetFilePath, localFilePath) {
                var transportService = Microsoft.VisualStudio.DiagnosticsHub.Collectors.getStandardTransportService();
                return transportService.downloadFile(targetFilePath, localFilePath);
            };
            ViewBaseController.prototype.onMessageReceived = function (message) {
                if (message) {
                    try {
                        var obj = JSON.parse(message);
                    }
                    catch (e) {
                        // If we get a non-JSON message here just ignore it
                        return;
                    }
                    if (obj.eventName) {
                        switch (obj.eventName) {
                            default:
                                break;
                        }
                    }
                }
                for (var i = this._activeCollectionAgentTasks.length - 1; i >= 0; i--) {
                    if (this._activeCollectionAgentTasks[i].isCompleted(message)) {
                        this._activeCollectionAgentTasks.splice(i, 1);
                    }
                }
            };
            ViewBaseController.prototype.completedTask = function (task) {
                var i = this._activeCollectionAgentTasks.indexOf(task);
                if (i >= 0)
                    this._activeCollectionAgentTasks.splice(i, 1);
            };
            ViewBaseController.prototype.sendMessage = function (message) {
                this._standardCollector.sendStringToCollectionAgent(this._agentGuid.toString(), message).done(function (response) {
                    if (response) {
                        var obj = JSON.parse(response);
                        if (!obj.succeeded) {
                            throw new Error(obj.errorMessage);
                        }
                    }
                });
            };
            ViewBaseController.prototype.appIsReadyToCapture = function () {
                this.view.appIsReadyToCapture();
            };
            ViewBaseController._frameChunkSize = 32768;
            ViewBaseController._nextIdentifier = 1;
            return ViewBaseController;
        }());
        Capture.ViewBaseController = ViewBaseController;
        var ViewModel = (function (_super) {
            __extends(ViewModel, _super);
            function ViewModel() {
                _super.call(this);
                this._warningMessage = "";
                this._latestFrameError = null;
                this._isCapturingFrame = false;
                this._pendingCaptureCount = 0;
                this._frameSummaryCollection = new VsGraphics.Common.Controls.ObservableCollection();
            }
            Object.defineProperty(ViewModel.prototype, "frameSummaryCollection", {
                get: function () { return this._frameSummaryCollection; },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewModel.prototype, "warningMessage", {
                get: function () { return this._warningMessage; },
                set: function (v) {
                    if (this._warningMessage !== v) {
                        this._warningMessage = v;
                        this.raisePropertyChanged("warningMessage");
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewModel.prototype, "latestFrameError", {
                get: function () { return this._latestFrameError; },
                set: function (v) {
                    if (this._latestFrameError !== v) {
                        this._latestFrameError = v;
                        this.raisePropertyChanged("latestFrameError");
                        // Create the WER
                        Capture.s_ViewHost.reportError(v, "FrameCapturingFailure");
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewModel.prototype, "isCapturingFrame", {
                get: function () { return this._isCapturingFrame; },
                set: function (v) {
                    if (this._isCapturingFrame !== v) {
                        this._isCapturingFrame = v;
                        this.raisePropertyChanged("isCapturingFrame");
                        this.raisePropertyChanged("isViewBusy");
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewModel.prototype, "pendingCaptureCount", {
                get: function () {
                    return this._pendingCaptureCount;
                },
                set: function (val) {
                    if (this._pendingCaptureCount !== val) {
                        this._pendingCaptureCount = val;
                        this.raisePropertyChanged("pendingCaptureCount");
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(ViewModel.prototype, "isViewBusy", {
                get: function () { return this._isCapturingFrame; },
                enumerable: true,
                configurable: true
            });
            return ViewModel;
        }(VsGraphics.Common.Controls.ObservableViewModel));
        Capture.ViewModel = ViewModel;
        var View = (function (_super) {
            __extends(View, _super);
            function View(controller, model, template) {
                _super.call(this, template);
                this.controller = controller;
                this.model = model;
                this.model.registerPropertyChanged(this);
                this.model.frameSummaryCollection.registerCollectionChanged(this);
                this._frameTileViewModelCollection = [];
                this.tilesContainer = this.findElement("tilesContainer");
                this._warningSection = this.findElement("warningSection");
            }
            Object.defineProperty(View.prototype, "frameTileViewModelCollection", {
                get: function () {
                    return this._frameTileViewModelCollection;
                },
                enumerable: true,
                configurable: true
            });
            View.prototype.onPropertyChanged = function (propertyName) {
                switch (propertyName) {
                    case "warningMessage":
                        this.showWarningMessage(this.model.warningMessage);
                        break;
                }
            };
            View.prototype.onCollectionChanged = function (eventArgs) {
                switch (eventArgs.action) {
                    case VsGraphics.Common.Controls.NotifyCollectionChangedAction.Add:
                        this.createTile(eventArgs.newItems[0]);
                        break;
                    case VsGraphics.Common.Controls.NotifyCollectionChangedAction.Reset:
                        this.removeFrameTiles();
                        break;
                }
            };
            View.prototype.removeFrameTiles = function () {
                this._frameTileViewModelCollection = [];
            };
            View.prototype.insertFrameTile = function (tile) {
                // Default is to just append
                this.tilesContainer.appendChild(tile.rootElement);
            };
            View.prototype.createTile = function (frameSummary) {
                // Create the model and the view
                var model = new Capture.FrameTileViewModel(frameSummary);
                var newTile = new Capture.FrameTileView(this.controller, model);
                this._frameTileViewModelCollection.push(model);
                // Turn off links if we are busy right now
                model.enabled = !this.model.isViewBusy;
                // Call our overload to insert the tile
                this.insertFrameTile(newTile);
            };
            View.prototype.showWarningMessage = function (warning) {
                if (!this._warningSection) {
                    return;
                }
                if (warning) {
                    this._warningSection.innerHTML = warning;
                    this._warningSection.style.display = "inline";
                }
                else {
                    this._warningSection.innerHTML = "";
                    this._warningSection.style.display = "none";
                }
            };
            View.prototype.appIsReadyToCapture = function () {
                // Implemented by the derived class.
            };
            return View;
        }(VsGraphics.Common.Controls.TemplateControl));
        Capture.View = View;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="IFrame.d.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        //
        // HostSessionProxy provides access to the Session which is implemented in the host
        //
        var HostSessionProxy = (function () {
            function HostSessionProxy() {
                this._sessionProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("GpuCapture.GpuCaptureSession", {}, true);
            }
            HostSessionProxy.prototype.addViewTypeEventListener = function (callback) {
                this._sessionProxy.addEventListener("viewtypechange", callback);
            };
            HostSessionProxy.prototype.getSessionInfo = function () {
                return this._sessionProxy._call("getSessionInfo");
            };
            HostSessionProxy.prototype.openFrameDetails = function (frameIndex, targetView) {
                return this._sessionProxy._call("openFrameDetails", frameIndex, targetView);
            };
            HostSessionProxy.prototype.getTempFilename = function (baseName) {
                return this._sessionProxy._call("getTempFilename", baseName);
            };
            HostSessionProxy.prototype.save = function () {
                return this._sessionProxy._call("save");
            };
            HostSessionProxy.prototype.addFrameProcessingEventListener = function (callback) {
                this._sessionProxy.addEventListener("frameProcessingComplete", callback);
            };
            HostSessionProxy.prototype.getFrameProcessingResults = function () {
                return this._sessionProxy._call("getFrameProcessingResults");
            };
            HostSessionProxy.prototype.getSessionStartupTime = function () {
                return this._sessionProxy._call("getSessionStartupTime");
            };
            HostSessionProxy.prototype.logCommandUsage = function (commandName, invokeMethod, source) {
                return this._sessionProxy._call("logCommandUsage", commandName, invokeMethod, source);
            };
            HostSessionProxy.prototype.logBeginLoadFrames = function () {
                return this._sessionProxy._call("logBeginLoadFrames");
            };
            HostSessionProxy.prototype.logEndLoadFrames = function () {
                return this._sessionProxy._call("logEndLoadFrames");
            };
            HostSessionProxy.prototype.setScriptedContextId = function (scriptedContextId) {
                return this._sessionProxy._call("setScriptedContextId", scriptedContextId);
            };
            HostSessionProxy.prototype.updateDetailsViewSetting = function (settingName, newValue) {
                return this._sessionProxy._call("updateDetailsViewSetting", settingName, newValue);
            };
            HostSessionProxy.prototype.getMaxFramesToCapture = function () {
                return this._sessionProxy._call("getMaxFramesToCapture");
            };
            HostSessionProxy.prototype.setNumFramesToCapture = function (numFramesToCapture) {
                return this._sessionProxy._call("setNumFramesToCapture", numFramesToCapture);
            };
            HostSessionProxy.prototype.addNumFramesToCaptureChangedEventListener = function (callback) {
                this._sessionProxy.addEventListener("numFramesToCaptureChanged", callback);
            };
            HostSessionProxy.prototype.startCapture = function () {
                return this._sessionProxy._call("startCapture");
            };
            HostSessionProxy.prototype.scriptedSandboxReadyToCapture = function () {
                return this._sessionProxy._call("scriptedSandboxReadyToCapture");
            };
            HostSessionProxy.prototype.selectFrame = function (frame) {
                return this._sessionProxy._call("selectFrame", frame);
            };
            HostSessionProxy.prototype.getFrames = function () {
                return this._sessionProxy._call("getFrames");
            };
            HostSessionProxy.prototype.addFrameCaptureBeginEventListener = function (callback) {
                this._sessionProxy.addEventListener("frameCaptureBegin", callback);
            };
            HostSessionProxy.prototype.addReadyToCaptureEventListener = function (callback) {
                this._sessionProxy.addEventListener("readyToCapture", callback);
            };
            return HostSessionProxy;
        }());
        Capture.HostSessionProxy = HostSessionProxy;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="Session.ts" />
/// <reference path="../../Common/controls/control.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var ViewHostBase = (function () {
            function ViewHostBase() {
                this._openCodeMarkers = {};
                Capture.s_ViewHost = this;
            }
            Object.defineProperty(ViewHostBase.prototype, "session", {
                get: function () { return this._session; },
                enumerable: true,
                configurable: true
            });
            ViewHostBase.prototype.loadView = function () {
                var _this = this;
                Microsoft.Plugin.addEventListener("pluginready", function () {
                    var session;
                    Microsoft.Plugin.Tooltip.defaultTooltipContentToHTML = false;
                    session = new Capture.HostSessionProxy();
                    _this._session = session;
                    _this.initializeErrorReporting();
                    Microsoft.Plugin.addEventListener("close", _this.onClose);
                    session.getSessionInfo().done(function (sessionInfo) {
                        _this.initializeView(sessionInfo);
                        _this.onIdle();
                    });
                });
            };
            ViewHostBase.prototype.initializeErrorReporting = function () {
                var _this = this;
                // Stop reporting errors to the WER service
                window.onerror = function (message, url, line, column, error) {
                    _this.reportError(new Error(message), "Unhandled Error", url, line, column);
                    return true;
                };
            };
            ViewHostBase.prototype.onIdle = function () {
                //Plugin.VS.Internal.CodeMarkers.fire(CodeMarkerValues.perfBrowserTools_MemoryProfilerIdle);
            };
            ViewHostBase.prototype.reportError = function (error, additionalInfo, source, line, column) {
                // Depending on the source, the error object will be different
                var message = (error.message || error.description);
                var url = source || "VsGraphics.Capture";
                var lineNumber = line || 0;
                var columnNumber = column || 0;
                var errorInfo = "Error description:  " + message;
                if (error.number) {
                    errorInfo += "\r\nError number:  " + error.number;
                }
                if (source) {
                    errorInfo += "\r\nSource:  " + source;
                }
                if (error.stack) {
                    var stack = error.stack;
                    errorInfo += "\r\nError stack:  " + stack;
                    // Find message if we dont have one already
                    if (!message) {
                        var index = stack.indexOf("\n");
                        if (index > 0) {
                            index = Math.min(index, 50);
                            message = stack.substring(0, index);
                        }
                    }
                    // Find url
                    if (typeof source === "undefined") {
                        var matchInfo = stack.match(/(file|res):?([^)]+)\)/);
                        if (matchInfo && matchInfo.length > 2) {
                            url = matchInfo[2];
                        }
                    }
                    // Find line number
                    if (typeof line === "undefined") {
                        matchInfo = stack.match(/line ?(\d+)/);
                        if (!matchInfo || matchInfo.length <= 1) {
                            matchInfo = stack.match(/js:?(\d+):/);
                        }
                        if (matchInfo && matchInfo.length > 1) {
                            lineNumber = parseInt(matchInfo[1]);
                        }
                    }
                }
                if (additionalInfo) {
                    errorInfo += "\r\nAdditional Info:  " + additionalInfo;
                }
                Microsoft.Plugin.Diagnostics.reportError(message, url, lineNumber, errorInfo, columnNumber);
            };
            ViewHostBase.prototype.onClose = function () {
                //Plugin.VS.Internal.CodeMarkers.fire(CodeMarkerValues.perfBrowserTools_MemoryProfilerWindowClose);
            };
            ViewHostBase.prototype.initializeView = function (sessionInfo) {
                // Nothing here. The subclasses override it.
            };
            return ViewHostBase;
        }());
        Capture.ViewHostBase = ViewHostBase;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="../../common/controls/componentModel.ts" />
/// <reference path="../../common/controls/templateControl.ts" />
/// <reference path="../../common/util/EnumHelper.ts" />
/// <reference path="../../common/util/errorFormatter.ts" />
/// <reference path="frameTileView.ts" />
/// <reference path="ViewHostBase.ts" />
/// <reference path="ViewTasks.ts" />
/// <reference path="IView.d.ts" />
/// <reference path="ViewBase.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var AnalysisViewController = (function (_super) {
            __extends(AnalysisViewController, _super);
            function AnalysisViewController(session, initializeView) {
                if (initializeView === void 0) { initializeView = true; }
                _super.call(this, session, initializeView);
                if (initializeView) {
                    this.view = new AnalysisView(this, this.model);
                }
                // Kick off a task to gather the current list of frames
                var task = new Capture.GetFramesTask(this, session);
                _super.prototype.addTask.call(this, task);
                task.start();
            }
            return AnalysisViewController;
        }(Capture.ViewBaseController));
        Capture.AnalysisViewController = AnalysisViewController;
        var AnalysisView = (function (_super) {
            __extends(AnalysisView, _super);
            function AnalysisView(controller, model) {
                _super.call(this, controller, model, "AnalysisViewTemplate");
            }
            return AnalysisView;
        }(Capture.View));
        Capture.AnalysisView = AnalysisView;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="../../common/controls/componentModel.ts" />
/// <reference path="../../common/controls/templateControl.ts" />
/// <reference path="../../common/util/EnumHelper.ts" />
/// <reference path="../../common/util/errorFormatter.ts" />
/// <reference path="frameTileView.ts" />
/// <reference path="ViewHostBase.ts" />
/// <reference path="ViewTasks.ts" />
/// <reference path="IView.d.ts" />
/// <reference path="ViewBase.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var CollectionViewController = (function (_super) {
            __extends(CollectionViewController, _super);
            function CollectionViewController(session, initializeView) {
                if (initializeView === void 0) { initializeView = true; }
                _super.call(this, session, initializeView);
                this._session = session;
                if (initializeView) {
                    this.view = new CollectionView(this, this.model);
                }
                this._captureFrameTask = new Capture.CaptureFrameTask(this, session);
            }
            CollectionViewController.prototype.captureFrame = function () {
                _super.prototype.addTask.call(this, this._captureFrameTask);
                return this._captureFrameTask.start();
            };
            CollectionViewController.prototype.readyToCapture = function () {
                this._captureFrameTask.setReady();
            };
            CollectionViewController.prototype.getMaxFramesToCapture = function () {
                return this._session.getMaxFramesToCapture();
            };
            CollectionViewController.prototype.setNumFramestoCapture = function (numFramesToCapture) {
                this._session.setNumFramesToCapture(numFramesToCapture);
            };
            return CollectionViewController;
        }(Capture.ViewBaseController));
        Capture.CollectionViewController = CollectionViewController;
        var CollectionView = (function (_super) {
            __extends(CollectionView, _super);
            function CollectionView(controller, model) {
                var _this = this;
                _super.call(this, controller, model, "CollectionViewTemplate");
                this._controller = controller;
                this._onNumFramesToCaptureChangeHandler = this.onNumFramesToCaptureChange.bind(this);
                this._onFrameClickHandler = this.onFrameClick.bind(this);
                var numFramesToCaptureLabel = this.findElement("numFramesToCaptureLabel");
                numFramesToCaptureLabel.innerText = Microsoft.Plugin.Resources.getString("NumFramesToCaptureLabel");
                this._numFramesToCaptureCombo = this.findElement("framesToCaptureCombo");
                this._captureFrameTile = this.findElement("captureFrameTile");
                this._toolbarCaptureButton = this.findElement("toolbarCaptureFrameButton");
                this._toolbarCaptureLabel = this.findElement("toolbarCaptureFrameLabel");
                this._toolbarCaptureLabel.innerText = Microsoft.Plugin.Resources.getString("CaptureFrame");
                this._frameProgress = this.findElement("captureFrameProgress");
                this._frameButton = this.findElement("captureFrameButton");
                this._frameLabel = this.findElement("captureFrameLabel");
                this._frameIcon = this.findElement("captureFrameIcon");
                this._frameLabel.innerText = Microsoft.Plugin.Resources.getString("CaptureFrame");
                this._frameProgress.innerText = Microsoft.Plugin.Resources.getString("Loading");
                this.toggleProgress(controller.isViewBusy);
                this.updateCaptureFrameButton();
                this._controller.getMaxFramesToCapture().done(function (maxFramesToCapture) {
                    for (var i = 1; i <= maxFramesToCapture; i++) {
                        var optionElement = document.createElement("option");
                        optionElement.innerText = i.toString();
                        _this._numFramesToCaptureCombo.appendChild(optionElement);
                    }
                });
                this._numFramesToCaptureCombo.addEventListener("change", this._onNumFramesToCaptureChangeHandler);
                this._toolbarCaptureButton.addEventListener("click", this._onFrameClickHandler);
                this._toolbarCaptureButton.addEventListener("keypress", this._onFrameClickHandler);
                this._captureFrameTile.addEventListener("click", this._onFrameClickHandler);
                this._captureFrameTile.addEventListener("keypress", this._onFrameClickHandler);
                this._captureFrameTile.hidden = true; // Hide until capture is ready, usable; otherwise, clicking it has no effect.
                // Support the "active" state. We can't use the :active pseudostate because it only works
                // on buttons
                this._captureFrameTile.onmousedown = function () {
                    this._captureFrameTile.classList.add("active");
                }.bind(this);
                this._captureFrameTile.onmouseup = function () {
                    this._captureFrameTile.classList.remove("active");
                }.bind(this);
                this._captureFrameTile.onmouseleave = function () {
                    this._captureFrameTile.classList.remove("active");
                }.bind(this);
            }
            CollectionView.prototype.UpdateNumFramesToCaptureSelection = function (numFramesToCapture) {
                if (this._numFramesToCaptureCombo != null) {
                    for (var i = 0; i < this._numFramesToCaptureCombo.length; i++) {
                        if (this._numFramesToCaptureCombo[i].innerText == numFramesToCapture.toString()) {
                            this._numFramesToCaptureCombo[i].selected = true;
                        }
                    }
                }
            };
            CollectionView.prototype.appIsReadyToCapture = function () {
                this._captureFrameTile.hidden = false;
            };
            CollectionView.prototype.onPropertyChanged = function (propertyName) {
                _super.prototype.onPropertyChanged.call(this, propertyName);
                switch (propertyName) {
                    case "isCapturingFrame":
                        this.toggleProgress(this.controller.isViewBusy);
                        this.updateCaptureFrameButton();
                        this.updateFrameAnalyzeButtons();
                        break;
                }
            };
            CollectionView.prototype.removeFrameTiles = function () {
                while (this.tilesContainer.hasChildNodes()) {
                    this.tilesContainer.removeChild(this.tilesContainer.firstChild);
                }
                this.tilesContainer.appendChild(this._captureFrameTile);
                _super.prototype.removeFrameTiles.call(this);
            };
            CollectionView.prototype.insertFrameTile = function (tile) {
                // For collection, we want to insert tiles before the capture frame tile
                this.tilesContainer.insertBefore(tile.rootElement, this._captureFrameTile);
                // Then make sure the capture frame tile stays visible
                this._captureFrameTile.scrollIntoView(true);
                // Give focus to the new tile so it leaves the capture frame tile
                tile.setFocus();
            };
            CollectionView.prototype.toggleProgress = function (show) {
                if (this._frameProgress) {
                    if (show) {
                        this._frameLabel.style.display = "none";
                        this._frameIcon.style.display = "none";
                        this._frameProgress.style.display = "block";
                        this._frameButton.style.display = "none";
                        this._frameButton.setAttribute("aria-label", Microsoft.Plugin.Resources.getString("Loading"));
                    }
                    else {
                        this._frameLabel.style.display = "";
                        this._frameIcon.style.display = "";
                        this._frameProgress.style.display = "none";
                        this._frameButton.style.display = "block";
                        this._frameButton.setAttribute("aria-label", Microsoft.Plugin.Resources.getString("CaptureFrame"));
                    }
                }
            };
            CollectionView.prototype.onNumFramesToCaptureChange = function (e) {
                var selectElement = e.srcElement;
                var numFramesToCapture = selectElement.options.item(selectElement.selectedIndex).innerText;
                this._controller.setNumFramestoCapture(parseInt(numFramesToCapture));
            };
            CollectionView.prototype.onFrameClick = function (e) {
                this._controller.captureFrame();
            };
            CollectionView.prototype.updateCaptureFrameButton = function () {
                if (this._frameButton) {
                    if (!this.model.isViewBusy) {
                        this._frameButton.classList.remove("disabled");
                        this._frameButton.disabled = false;
                    }
                    else {
                        this._frameButton.disabled = true;
                    }
                }
            };
            CollectionView.prototype.updateFrameAnalyzeButtons = function () {
                var _this = this;
                this.frameTileViewModelCollection.forEach(function (m) {
                    m.enabled = !_this.model.isViewBusy; // Should fire a property changed event that will cause the link to disable itself
                });
            };
            return CollectionView;
        }(Capture.View));
        Capture.CollectionView = CollectionView;
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="Session.ts" />
/// <reference path="../../Common/controls/control.ts" />
/// <reference path="../../Common/controls/componentModel.ts" />
/// <reference path="ViewHostBase.ts" />
/// <reference path="AnalysisView.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var AnalysisViewHost = (function (_super) {
            __extends(AnalysisViewHost, _super);
            function AnalysisViewHost() {
                _super.call(this);
            }
            AnalysisViewHost.prototype.onPropertyChanged = function (propertyName) {
            };
            AnalysisViewHost.prototype.initializeView = function (sessionInfo) {
                this.viewController = new Capture.AnalysisViewController(this.session);
                var mainContainer = document.getElementById('mainContainer');
                mainContainer.appendChild(this.viewController.view.rootElement);
                this.viewController.model.registerPropertyChanged(this);
                this.initCommands();
            };
            AnalysisViewHost.prototype.initCommands = function () {
            };
            return AnalysisViewHost;
        }(Capture.ViewHostBase));
        Capture.AnalysisViewHost = AnalysisViewHost;
        Capture.AnalysisViewHostInstance = new AnalysisViewHost();
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="../../Common/controls/componentModel.ts" />
/// <reference path="CollectionViewHost.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
//
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../../Common/Includes.ts" />
/// <reference path="Session.ts" />
/// <reference path="../../Common/controls/control.ts" />
/// <reference path="../../Common/controls/componentModel.ts" />
/// <reference path="ViewHostBase.ts" />
/// <reference path="CollectionView.ts" />
/// <reference path="VsPluginCommandHelper.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Capture;
    (function (Capture) {
        "use strict";
        var CollectionViewHost = (function (_super) {
            __extends(CollectionViewHost, _super);
            function CollectionViewHost() {
                _super.call(this);
            }
            CollectionViewHost.prototype.sessionStateChanged = function (eventArgs) {
                var currentState = eventArgs.currentState;
                switch (currentState) {
                    case 400 /* CollectionFinishing */:
                        //CollectionViewHost.CommandChain.onCollectionFinishing();
                        break;
                    case 500 /* CollectionFinished */:
                        Microsoft.VisualStudio.DiagnosticsHub.getCurrentSession().removeStateChangedEventListener(this.sessionStateChanged);
                        // Have session persist our session metadata now
                        var eventCompleteDeferral = eventArgs.getDeferral();
                        var onSaveCompleted = function (value) {
                            eventCompleteDeferral.complete();
                        };
                        this.session.save().done(onSaveCompleted);
                        break;
                }
            };
            CollectionViewHost.prototype.onPropertyChanged = function (propertyName) {
                //CollectionViewHost.CommandChain.onPropertyChanged(propertyName);
            };
            CollectionViewHost.prototype.initializeView = function (sessionInfo) {
                this.collectionViewController = new Capture.CollectionViewController(this.session);
                var mainContainer = document.getElementById('mainContainer');
                mainContainer.appendChild(this.collectionViewController.view.rootElement);
                this.collectionViewController.model.registerPropertyChanged(this);
                Microsoft.VisualStudio.DiagnosticsHub.getCurrentSession().addStateChangedEventListener(this.sessionStateChanged.bind(this));
                //Microsoft.Plugin.addEventListener("close", () => {
                //    CollectionViewHost.CommandChain.onClose();
                //});
                this.session.addNumFramesToCaptureChangedEventListener(this.onNumFramesToCaptureChanged.bind(this));
                this.session.addFrameCaptureBeginEventListener(this.onCaptureBegin.bind(this));
                // Add this message box to simulate a scripted sandbox being slower to initialize than the experiment/app.
                // window.alert("wait");
                this.session.addReadyToCaptureEventListener(this.onReadyToCapture.bind(this));
                this.session.scriptedSandboxReadyToCapture();
                this.appReadyToCapture = false;
                this.initCommands();
            };
            CollectionViewHost.prototype.initCommands = function () {
                //if (Microsoft.Plugin.VS && Microsoft.Plugin.VS.Commands) {
                //    var captureFrameCommand = new CaptureFrameCommand(this);
                //    CollectionViewHost.CommandChain = captureFrameCommand;
                //    var toolbar = new Microsoft.VisualStudio.DiagnosticsHub.Toolbar();
                //    toolbar.addToolbarItem(captureFrameCommand);
                //    var toolbarSection = document.getElementsByClassName('toolbarSection')[0];
                //    toolbarSection.appendChild(toolbar.container);
                //}
            };
            CollectionViewHost.prototype.onNumFramesToCaptureChanged = function (result) {
                if (!result) {
                    throw new Error("<move to resources>: onNumFramesToCaptureChanged ended with no response");
                }
                this.collectionViewController.view.UpdateNumFramesToCaptureSelection(result.numFramesToCapture);
            };
            CollectionViewHost.prototype.onCaptureBegin = function (result) {
                if (!result) {
                    throw new Error("<move to resources>: frameAsync ended with no response");
                }
                // Indicate we are capturing
                if (this.appReadyToCapture) {
                    this.collectionViewController.isCapturingFrame = true;
                    this.collectionViewController.pendingCaptureCount = result.numberOfFrames;
                }
            };
            CollectionViewHost.prototype.onReadyToCapture = function (result) {
                if (!result) {
                    throw new Error("<move to resources>: frameAsync ended with no response");
                }
                // Indicate we are ready to capture
                this.appReadyToCapture = true;
                this.collectionViewController.readyToCapture();
            };
            return CollectionViewHost;
        }(Capture.ViewHostBase));
        Capture.CollectionViewHost = CollectionViewHost;
        Capture.CollectionViewHostInstance = new CollectionViewHost();
    })(Capture = VsGraphics.Capture || (VsGraphics.Capture = {}));
})(VsGraphics || (VsGraphics = {}));
/// <reference path="..\Common\Includes.ts" />
var Microsoft;
(function (Microsoft) {
    var GpuProfiling;
    (function (GpuProfiling) {
        var GpuProfilingDetailsControl = (function () {
            function GpuProfilingDetailsControl(config) {
                // View activation
                this._isActive = false;
                // Data warehouse
                this._dataWarehouse = null;
                // Local fields
                this._loadingDetails = false;
                this._E_ACCESSDENIED = 0x80070005;
                this._E_OUTOFMEMORY = 0x8007000E;
                if (config && config.viewId) {
                    this._config = config;
                    this._viewId = config.viewId;
                }
                else {
                    throw new Error("Invalid Config.");
                }
                this._vsSession = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("GpuProfiler.GpuProfilingSession", {}, true);
                this.setInitialControls();
                // Register our callback function for when VS has finished loading details data
                this._vsSession.addEventListener("gpudetailsloaded", this.onGpuDetailsLoaded.bind(this));
                // Register our callback function to handle test automation
                this._vsSession.addEventListener("testopendetails", this.onGpuDetailsOpenTest.bind(this));
                this._viewEventManager = Microsoft.VisualStudio.DiagnosticsHub.getViewEventManager();
                this._viewEventManager.selectionChanged.addEventListener(this.onRulerSelectionChanged.bind(this));
                // Set our timespan to zero to begin with
                this._timeSpan = new Microsoft.VisualStudio.DiagnosticsHub.JsonTimespan(new Microsoft.VisualStudio.DiagnosticsHub.BigNumber(0, 0), new Microsoft.VisualStudio.DiagnosticsHub.BigNumber(0, 0));
                // Load the DataWarehouse
                Microsoft.VisualStudio.DiagnosticsHub.DataWarehouse.loadDataWarehouse()
                    .then(function (dw) {
                    this._dataWarehouse = dw;
                    // Notify the hub that we have loaded our view
                    this._viewEventManager.detailsViewReady.raiseEvent({
                        Id: this._viewId
                    });
                    // When we first load up, query the analyzer to see if there were any errors during analysis
                    this.checkAnalysisErrors();
                }.bind(this));
            }
            GpuProfilingDetailsControl.prototype.onGpuDetailsLoaded = function (args) {
                this._loadingDetails = false;
                this.showLink();
            };
            GpuProfilingDetailsControl.prototype.onGpuDetailsOpenTest = function (args) {
                this.loadGpuDetailsDataFromTime(args.startTime, args.endTime);
            };
            GpuProfilingDetailsControl.prototype.checkAnalysisErrors = function () {
                // Request Error check data from our analyzer
                var customData = {
                    task: "ERRORCHECK"
                };
                var contextData = {
                    customDomain: customData,
                };
                var dataPromise = this._dataWarehouse.getFilteredData(contextData, "9187AE0A-6018-4ADA-BA36-43D4E9BE0834");
                dataPromise.then(function (result) {
                    var myResult = result.getResult("");
                    myResult.then(function (realResult) {
                        // Since JS Number values are unsigned do a quick convert here if needed
                        if (realResult.HRESULT < 0) {
                            this._analysisHResult = 0x100000000 + realResult.HRESULT;
                        }
                        else {
                            this._analysisHResult = realResult.HRESULT;
                        }
                        // Hide / Show the main controls or warnings based on analysis results from the infosource
                        // Good Result
                        if (this._analysisHResult == 0x0) {
                            var linkDiv = document.getElementById("Gpu-Details-Main");
                            linkDiv.style.visibility = "visible";
                        }
                        else if ((this._analysisHResult == this._E_ACCESSDENIED) || (this._analysisHResult == this._E_OUTOFMEMORY)) {
                            var warningDiv = document.getElementById("Analysis-Warnings-Container");
                            warningDiv.style.visibility = "visible";
                            var warningSpan = document.getElementById("Analysis-Warnings-Span");
                            warningSpan.innerText = Microsoft.Plugin.Resources.getString("ProfilingAnalysisMemoryError");
                        }
                        else {
                            var warningDiv = document.getElementById("Analysis-Warnings-Container");
                            warningDiv.style.visibility = "visible";
                            var warningSpan = document.getElementById("Analysis-Warnings-Span");
                            warningSpan.innerText = Microsoft.Plugin.Resources.getString("ProfilingAnalysisOtherError", this._analysisHResult.toString(16));
                        }
                    }.bind(this));
                }.bind(this));
            };
            // Grab data from our infosource and load it into shared memory
            // pass back to VS the location and details of that memory
            GpuProfilingDetailsControl.prototype.loadGpuDetailsData = function () {
                var startString = this._timeSpan.begin.value;
                var endString = this._timeSpan.end.value;
                this.loadGpuDetailsDataFromTime(startString, endString);
            };
            GpuProfilingDetailsControl.prototype.loadGpuDetailsDataFromTime = function (startTime, endTime) {
                // Prevent the user from loading another chunk until the first is loaded
                if (!this._loadingDetails) {
                    this._loadingDetails = true;
                    this.hideLink();
                    this._dataWarehouse.getContextService().getGlobalContext()
                        .then(function (context) {
                        this._context = context;
                        // After we have grabbed the global context, call into the data warehouse to get data
                        var dataPromise = this._dataWarehouse.getData(context.getContextId(), "9187AE0A-6018-4ADA-BA36-43D4E9BE0834");
                        dataPromise.then(function (result) {
                            var timespanString = startTime + ":" + endTime;
                            var myResult = result.getResult(timespanString);
                            myResult.then(function (realResult) {
                                this._vsSession._call("asyncOpenGpuDetails", realResult);
                            }.bind(this));
                        }.bind(this));
                    }.bind(this));
                }
            };
            GpuProfilingDetailsControl.prototype.setInitialControls = function () {
                var prefix1 = document.getElementById("detailsPrefix1");
                prefix1.innerText = Microsoft.Plugin.Resources.getString("ProfilingSelectMessagePrefix1");
                var prefix2 = document.getElementById("detailsPrefix2");
                prefix2.innerText = Microsoft.Plugin.Resources.getString("ProfilingSelectMessagePrefix2");
                var suffix = document.getElementById("detailsSuffix");
                suffix.innerText = Microsoft.Plugin.Resources.getString("ProfilingSelectMessageSuffix");
                this._detailsLink = document.getElementById("detailsLink");
                this._detailsLink.href = "javascript:void(null);";
                this._detailsLink.innerText = Microsoft.Plugin.Resources.getString("ProfilingSelectMessageLink");
                this._detailsLink.addEventListener("click", this.openDetailsPage.bind(this));
                // External Tools Controls
                var wpaLink = document.getElementById("wpaLink");
                wpaLink.href = "javascript:void(null);";
                wpaLink.addEventListener("click", this.openWpaLink.bind(this));
                wpaLink.style.visibility = "hidden";
                wpaLink.innerText = Microsoft.Plugin.Resources.getString("WpaLinkText");
                wpaLink.title = Microsoft.Plugin.Resources.getString("WpaLinkTitle");
                var gpuViewLink = document.getElementById("gpuViewLink");
                gpuViewLink.href = "javascript:void(null);";
                gpuViewLink.addEventListener("click", this.openGpuViewLink.bind(this));
                gpuViewLink.style.visibility = "hidden";
                gpuViewLink.innerText = Microsoft.Plugin.Resources.getString("GpuViewLinkText");
                gpuViewLink.title = Microsoft.Plugin.Resources.getString("GpuViewLinkTitle");
                this.checkWpaAvailable();
                this.checkGpuViewAvailable();
                var progressSpan = document.getElementById("inProgressSpan");
                progressSpan.innerText = Microsoft.Plugin.Resources.getString("ProfilingInProgressMessage");
                // Initially hide all controls (don't enable until we know our analysis was correct)
                var linkDiv = document.getElementById("Gpu-Details-Main");
                linkDiv.style.visibility = "hidden";
                var progressDiv = document.getElementById("Gpu-Details-Progress");
                progressDiv.style.visibility = "hidden";
                var warningDiv = document.getElementById("Analysis-Warnings-Container");
                warningDiv.style.visibility = "hidden";
            };
            // Show the open document link and hide the in progress link
            GpuProfilingDetailsControl.prototype.showLink = function () {
                var open = document.getElementById("Gpu-Details-Main");
                open.style.visibility = "visible";
                var progress = document.getElementById("Gpu-Details-Progress");
                progress.style.visibility = "hidden";
            };
            // Hide the open document link and show the in progress link
            GpuProfilingDetailsControl.prototype.hideLink = function () {
                var open = document.getElementById("Gpu-Details-Main");
                open.style.visibility = "hidden";
                var progress = document.getElementById("Gpu-Details-Progress");
                progress.style.visibility = "visible";
            };
            GpuProfilingDetailsControl.prototype.onRulerSelectionChanged = function (args) {
                // Only update when selection is complete, not during the selection event
                if (!args.isIntermittent) {
                    this._timeSpan = args.position;
                }
            };
            GpuProfilingDetailsControl.prototype.openWpaLink = function () {
                this.openWpa();
            };
            GpuProfilingDetailsControl.prototype.checkWpaAvailable = function () {
                this._vsSession._call("WPAIsAvailable").done(function (result) {
                    if (result) {
                        var wpaLink = document.getElementById("wpaLink");
                        wpaLink.style.visibility = "visible";
                    }
                });
            };
            GpuProfilingDetailsControl.prototype.openWpa = function () {
                this._vsSession._call("launchInWPA").done(function (result) {
                });
            };
            GpuProfilingDetailsControl.prototype.openGpuViewLink = function () {
                this.openGpuView();
            };
            GpuProfilingDetailsControl.prototype.checkGpuViewAvailable = function () {
                this._vsSession._call("GpuViewIsAvailable").done(function (result) {
                    if (result) {
                        var gpuViewLink = document.getElementById("gpuViewLink");
                        gpuViewLink.style.visibility = "visible";
                    }
                });
            };
            GpuProfilingDetailsControl.prototype.openGpuView = function () {
                this._vsSession._call("launchInGpuView").done(function (result) {
                });
            };
            GpuProfilingDetailsControl.prototype.openDetailsPage = function () {
                this.loadGpuDetailsData();
            };
            return GpuProfilingDetailsControl;
        }());
        GpuProfiling.GpuProfilingDetailsControl = GpuProfilingDetailsControl;
    })(GpuProfiling = Microsoft.GpuProfiling || (Microsoft.GpuProfiling = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var GpuProfiling;
    (function (GpuProfiling) {
        var GpuProfilingRuntimeControl = (function () {
            // Pass in a view configuration block from the control
            function GpuProfilingRuntimeControl(config) {
                this._agentGuid = new Microsoft.VisualStudio.DiagnosticsHub.Guid("9e5de5fb-d655-401a-86a8-5764c252744d");
                if (config && config.viewId) {
                    this._config = config;
                    this._viewId = config.viewId;
                }
                else {
                    throw new Error("Invalid Config.");
                }
                this.setInitialControls();
                this._vsSession = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("GpuProfiler.GpuProfilingSession", {}, true);
                this._standardCollector = Microsoft.VisualStudio.DiagnosticsHub.Collectors.getStandardTransportService();
                this._standardCollector.addMessageListener(this._agentGuid, this.onMessageReceived.bind(this));
            }
            // Messaged from the collector come in here to be handled
            GpuProfilingRuntimeControl.prototype.onMessageReceived = function (message) {
                if (message) {
                    if (message == "Started") {
                        this.setControls(true);
                    }
                    else if (message == "NotStarted") {
                        this.setControls(false);
                    }
                    else {
                        this._vsSession._call("sendStringMessage", message);
                    }
                }
            };
            // The initial set of controls will be all hidden until the collector tells us if we need the "start profiling" link or not
            GpuProfilingRuntimeControl.prototype.setInitialControls = function () {
                this._startLink = document.getElementById("startLink");
                this._startSpan = document.getElementById("startSpan");
                this._stopLink = document.getElementById("stopLink");
                this._stopSpan = document.getElementById("stopSpan");
                this._stopLink.style.visibility = "hidden";
                this._stopSpan.style.visibility = "hidden";
                this._startLink.style.visibility = "hidden";
                this._startSpan.style.visibility = "hidden";
            };
            // Set up our various HTML controls
            GpuProfilingRuntimeControl.prototype.setControls = function (started) {
                this._startLink.innerText = Microsoft.Plugin.Resources.getString("ProfilingStartProfilingLink");
                this._startLink.href = "javascript:void(null);";
                this._startLink.addEventListener("click", this.startProfiling.bind(this));
                this._startLink.style.visibility = "visible";
                this._startSpan.innerText = Microsoft.Plugin.Resources.getString("ProfilingStartProfilingSpan");
                this._startSpan.style.visibility = "visible";
                this._stopLink.innerText = Microsoft.Plugin.Resources.getString("ProfilingStopProfilingLink");
                this._stopLink.href = "javascript:void(null);";
                this._stopLink.addEventListener("click", this.stopProfiling.bind(this));
                this._stopLink.style.visibility = "visible";
                this._stopSpan.innerText = Microsoft.Plugin.Resources.getString("ProfilingStopProfilingSpan");
                this._stopSpan.style.visibility = "visible";
                if (started) {
                    this._startLink.style.visibility = "hidden";
                    this._startSpan.style.visibility = "hidden";
                }
            };
            GpuProfilingRuntimeControl.prototype.stopProfiling = function () {
                // Hide the links to prevent an accidental second press
                // were closing down now, so we don't want a command to start or
                // a second stop command
                this._stopLink.style.visibility = "hidden";
                this._stopSpan.style.visibility = "hidden";
                this._startLink.style.visibility = "hidden";
                this._startSpan.style.visibility = "hidden";
                this._vsSession._call("closeSession");
            };
            GpuProfilingRuntimeControl.prototype.startProfiling = function () {
                // Hide the start link when we begin
                this._startLink.style.visibility = "hidden";
                this._startSpan.style.visibility = "hidden";
                var startString = "StartProfiling:" + Microsoft.Plugin.Resources.getString("ProfilingUserMark");
                // Send our message to start profiling to the collection agent
                this._standardCollector.sendStringToCollectionAgent(this._agentGuid.toString(), startString).done(function (response) {
                    if (response) {
                        var str = response;
                    }
                });
            };
            return GpuProfilingRuntimeControl;
        }());
        GpuProfiling.GpuProfilingRuntimeControl = GpuProfilingRuntimeControl;
    })(GpuProfiling = Microsoft.GpuProfiling || (Microsoft.GpuProfiling = {}));
})(Microsoft || (Microsoft = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="control.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            "use strict";
            // This ContentControl is  a control that only allows a single child (content).
            var ContentControl = (function (_super) {
                __extends(ContentControl, _super);
                function ContentControl() {
                    _super.call(this);
                }
                Object.defineProperty(ContentControl.prototype, "content", {
                    get: function () { return this._content; },
                    set: function (newContent) {
                        if (this._content !== newContent) {
                            if (this._content) {
                                this.removeChild(this._content);
                            }
                            this._content = newContent;
                            this.appendChild(this._content);
                            this.onContentChanged();
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                ContentControl.prototype.appendChild = function (child) {
                    if (this.rootElement.children.length != 0) {
                        throw new Error(Microsoft.Plugin.Resources.getErrorString("MemProf.1016"));
                    }
                    _super.prototype.appendChild.call(this, child);
                };
                // overridable
                ContentControl.prototype.onContentChanged = function () {
                };
                return ContentControl;
            }(Controls.Control));
            Controls.ContentControl = ContentControl;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        "use strict";
        /**
        Use the Keys members to test against KeyboardEvent.key.
        This is preferred over testing KeyboardEvent.keyCode, which is deprecated.
        */
        var Keys = (function () {
            function Keys() {
            }
            Keys.c = "c";
            Keys.DEL = "Del";
            Keys.DOWN = "Down";
            Keys.END = "End";
            Keys.ENTER = "Enter";
            Keys.F10 = "F10";
            Keys.HOME = "Home";
            Keys.LEFT = "Left";
            Keys.RIGHT = "Right";
            Keys.SPACEBAR = "Spacebar";
            Keys.UP = "Up";
            return Keys;
        }());
        Common.Keys = Keys;
        /**
        Use the KeyCodes enumeration to test against KeyboardEvent.keyCode.
        This is deprecated in favor of testing KeyboardEvent.key.
        */
        (function (KeyCodes) {
            KeyCodes[KeyCodes["BACKSPACE"] = 8] = "BACKSPACE";
            KeyCodes[KeyCodes["TAB"] = 9] = "TAB";
            KeyCodes[KeyCodes["ENTER"] = 13] = "ENTER";
            KeyCodes[KeyCodes["SHIFT"] = 16] = "SHIFT";
            KeyCodes[KeyCodes["CONTROL"] = 17] = "CONTROL";
            KeyCodes[KeyCodes["ALT"] = 18] = "ALT";
            KeyCodes[KeyCodes["CAPS_LOCK"] = 20] = "CAPS_LOCK";
            KeyCodes[KeyCodes["ESCAPE"] = 27] = "ESCAPE";
            KeyCodes[KeyCodes["SPACE"] = 32] = "SPACE";
            KeyCodes[KeyCodes["PAGE_UP"] = 33] = "PAGE_UP";
            KeyCodes[KeyCodes["PAGE_DOWN"] = 34] = "PAGE_DOWN";
            KeyCodes[KeyCodes["END"] = 35] = "END";
            KeyCodes[KeyCodes["HOME"] = 36] = "HOME";
            KeyCodes[KeyCodes["ARROW_LEFT"] = 37] = "ARROW_LEFT";
            KeyCodes[KeyCodes["ARROW_FIRST"] = 37] = "ARROW_FIRST";
            KeyCodes[KeyCodes["ARROW_UP"] = 38] = "ARROW_UP";
            KeyCodes[KeyCodes["ARROW_RIGHT"] = 39] = "ARROW_RIGHT";
            KeyCodes[KeyCodes["ARROW_DOWN"] = 40] = "ARROW_DOWN";
            KeyCodes[KeyCodes["ARROW_LAST"] = 40] = "ARROW_LAST";
            KeyCodes[KeyCodes["INSERT"] = 45] = "INSERT";
            KeyCodes[KeyCodes["DELETE"] = 46] = "DELETE";
            KeyCodes[KeyCodes["A"] = 65] = "A";
            KeyCodes[KeyCodes["B"] = 66] = "B";
            KeyCodes[KeyCodes["C"] = 67] = "C";
            KeyCodes[KeyCodes["D"] = 68] = "D";
            KeyCodes[KeyCodes["E"] = 69] = "E";
            KeyCodes[KeyCodes["F"] = 70] = "F";
            KeyCodes[KeyCodes["G"] = 71] = "G";
            KeyCodes[KeyCodes["H"] = 72] = "H";
            KeyCodes[KeyCodes["I"] = 73] = "I";
            KeyCodes[KeyCodes["J"] = 74] = "J";
            KeyCodes[KeyCodes["K"] = 75] = "K";
            KeyCodes[KeyCodes["L"] = 76] = "L";
            KeyCodes[KeyCodes["M"] = 77] = "M";
            KeyCodes[KeyCodes["N"] = 78] = "N";
            KeyCodes[KeyCodes["O"] = 79] = "O";
            KeyCodes[KeyCodes["P"] = 80] = "P";
            KeyCodes[KeyCodes["Q"] = 81] = "Q";
            KeyCodes[KeyCodes["R"] = 82] = "R";
            KeyCodes[KeyCodes["S"] = 83] = "S";
            KeyCodes[KeyCodes["T"] = 84] = "T";
            KeyCodes[KeyCodes["U"] = 85] = "U";
            KeyCodes[KeyCodes["V"] = 86] = "V";
            KeyCodes[KeyCodes["W"] = 87] = "W";
            KeyCodes[KeyCodes["X"] = 88] = "X";
            KeyCodes[KeyCodes["Y"] = 89] = "Y";
            KeyCodes[KeyCodes["Z"] = 90] = "Z";
            KeyCodes[KeyCodes["CONTEXTMENU"] = 93] = "CONTEXTMENU";
            KeyCodes[KeyCodes["MULTIPLY"] = 106] = "MULTIPLY";
            KeyCodes[KeyCodes["PLUS"] = 107] = "PLUS";
            KeyCodes[KeyCodes["MINUS"] = 109] = "MINUS";
            KeyCodes[KeyCodes["F1"] = 112] = "F1";
            KeyCodes[KeyCodes["F2"] = 113] = "F2";
            KeyCodes[KeyCodes["F3"] = 114] = "F3";
            KeyCodes[KeyCodes["F4"] = 115] = "F4";
            KeyCodes[KeyCodes["F5"] = 116] = "F5";
            KeyCodes[KeyCodes["F6"] = 117] = "F6";
            KeyCodes[KeyCodes["F7"] = 118] = "F7";
            KeyCodes[KeyCodes["F8"] = 119] = "F8";
            KeyCodes[KeyCodes["F9"] = 120] = "F9";
            KeyCodes[KeyCodes["F10"] = 121] = "F10";
            KeyCodes[KeyCodes["F11"] = 122] = "F11";
            KeyCodes[KeyCodes["F12"] = 123] = "F12";
            KeyCodes[KeyCodes["COMMA"] = 188] = "COMMA";
            KeyCodes[KeyCodes["PERIOD"] = 190] = "PERIOD";
        })(Common.KeyCodes || (Common.KeyCodes = {}));
        var KeyCodes = Common.KeyCodes;
        (function (MouseButtons) {
            MouseButtons[MouseButtons["LEFT_BUTTON"] = 0] = "LEFT_BUTTON";
            MouseButtons[MouseButtons["MIDDLE_BUTTON"] = 1] = "MIDDLE_BUTTON";
            MouseButtons[MouseButtons["RIGHT_BUTTON"] = 2] = "RIGHT_BUTTON";
        })(Common.MouseButtons || (Common.MouseButtons = {}));
        var MouseButtons = Common.MouseButtons;
        // This maps to KeyFlags enum defined in 
        // $/devdiv/feature/VSClient_1/src/bpt/diagnostics/Host/Common/common.h
        (function (KeyFlags) {
            KeyFlags[KeyFlags["KeyFlags_None"] = 0] = "KeyFlags_None";
            KeyFlags[KeyFlags["KeyFlags_Shift"] = 1] = "KeyFlags_Shift";
            KeyFlags[KeyFlags["KeyFlags_Ctrl"] = 2] = "KeyFlags_Ctrl";
            KeyFlags[KeyFlags["KeyFlags_Alt"] = 4] = "KeyFlags_Alt";
        })(Common.KeyFlags || (Common.KeyFlags = {}));
        var KeyFlags = Common.KeyFlags;
        /**
           Add listeners to the document to prevent certain IE browser accelerator keys from
           triggering their default action in IE
         */
        function blockBrowserAccelerators() {
            // Prevent the default F5 refresh, default F6 address bar focus, and default SHIFT + F10 context menu
            document.addEventListener("keydown", function (e) {
                return preventIEKeys(e);
            });
            // Prevent the default context menu
            document.addEventListener("contextmenu", function (e) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            });
            // Prevent mouse wheel zoom
            window.addEventListener("mousewheel", function (e) {
                if (e.ctrlKey) {
                    e.preventDefault();
                    e.stopPropagation();
                    return false;
                }
            });
        }
        Common.blockBrowserAccelerators = blockBrowserAccelerators;
        /**
           Checks to see if any of the ALT, SHIFT, or CTRL keys are pressed
           @param e The keyboard event to check
           @returns true if the event has any of the key flags toggled on
         */
        function HasAnyOfAltCtrlShiftKeyFlags(e) {
            return e.shiftKey || e.ctrlKey || e.altKey;
        }
        Common.HasAnyOfAltCtrlShiftKeyFlags = HasAnyOfAltCtrlShiftKeyFlags;
        /**
           Prevents IE from executing default behavior for certain shortcut keys
           This should be called from keydown handlers that do not already call preventDefault().
           Some shortcuts cannot be blocked via javascript (such as CTRL + P print dialog) so these
           are already blocked by the native hosting code and will not get sent to the key event handlers.
           @param e The keyboard event to check and prevent the action on
           @returns false to stop the default action- which matches the keydown/keyup handlers
         */
        function preventIEKeys(e) {
            // Check if a known key combo is pressed
            if (e.keyCode === Common.KeyCodes.F5 ||
                e.keyCode === Common.KeyCodes.F6 ||
                (e.keyCode === Common.KeyCodes.F10 && e.shiftKey) ||
                (e.keyCode === Common.KeyCodes.F && e.ctrlKey)) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
            return true;
        }
        Common.preventIEKeys = preventIEKeys;
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../Includes.ts" />
/// <reference path="../Util/KeyCodes.ts" />
/// <reference path="control.ts" />
/// <reference path="templateControl.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            "use strict";
            var MenuItem = (function () {
                function MenuItem(itemText, ownerControl, canToggle, initialState) {
                    if (canToggle === void 0) { canToggle = false; }
                    if (initialState === void 0) { initialState = false; }
                    this.element = document.createElement("li");
                    if (canToggle) {
                        this._toggleIcon = document.createElement("img");
                        this.element.appendChild(this._toggleIcon);
                        this._toggleIcon.className = "menuToggleIcon";
                        this._toggleIcon.src = Microsoft.Plugin.Theme.getValue("image-checkmark");
                        this.toggled = initialState;
                        this.element.addEventListener("DOMAttrModified", this.onAriaCheckedModified.bind(this));
                    }
                    var span = document.createElement("span");
                    this.element.appendChild(span);
                    span.innerText = itemText;
                }
                Object.defineProperty(MenuItem.prototype, "toggled", {
                    get: function () { return this._toggled; },
                    set: function (v) {
                        this._toggled = v;
                        if (this._toggled) {
                            this._toggleIcon.classList.remove("hiddenCheckMark");
                            this.element.setAttribute("aria-checked", "true");
                        }
                        else {
                            this._toggleIcon.classList.add("hiddenCheckMark");
                            this.element.setAttribute("aria-checked", "false");
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                MenuItem.prototype.onAriaCheckedModified = function (event) {
                    if (event.attrName === "aria-checked") {
                        var checked = event.newValue === "true";
                        if (this.toggled !== checked)
                            this.toggled = checked;
                    }
                };
                return MenuItem;
            }());
            Controls.MenuItem = MenuItem;
            var MenuControl = (function (_super) {
                __extends(MenuControl, _super);
                function MenuControl(target) {
                    var _this = this;
                    _super.call(this);
                    this._target = target;
                    this._isVisible = false;
                    this.setTemplateFromHTML("<ul id=\"menuControl\" class=\"menuControl\" role=\"menu\"></ul>");
                    this._listElement = this.findElement("menuControl");
                    this._listElement.setAttribute("aria-hidden", "true");
                    this._closeMenuFunction = this.closeMenu.bind(this);
                    document.body.addEventListener("keydown", function (e) {
                        if (e.keyCode === Common.KeyCodes.ESCAPE) {
                            _this.closeMenu();
                        }
                    });
                    target.onclick = this.showMenu.bind(this);
                    target.onkeydown = function (e) {
                        if (e.keyCode === Common.KeyCodes.ENTER || e.keyCode === Common.KeyCodes.SPACE) {
                            if (!_this._isVisible)
                                _this.showMenu();
                            else
                                _this.closeMenu();
                        }
                    };
                    target.appendChild(this._listElement);
                    target.setAttribute("role", "button");
                    target.setAttribute("aria-haspopup", "true");
                    target.setAttribute("aria-owns", this._listElement.id.toString());
                    target.addEventListener("keydown", function (e) {
                        if ((e.keyCode === Common.KeyCodes.ARROW_DOWN) && (_this._isVisible)) {
                            _this._listElement.firstElementChild.focus();
                        }
                    });
                }
                MenuControl.prototype.getMenuItem = function (index) {
                    if (index >= 0 && index < this._listElement.children.length) {
                        return this._listElement.children[index];
                    }
                    return null;
                };
                MenuControl.prototype.addToggleItem = function (itemText, itemCallback, initialState, tabIndex) {
                    if (initialState === void 0) { initialState = false; }
                    if (tabIndex === void 0) { tabIndex = 0; }
                    var menuItem = new MenuItem(itemText, this, true, initialState);
                    this._listElement.appendChild(menuItem.element);
                    menuItem.element.tabIndex = tabIndex;
                    menuItem.element.setAttribute("role", "menuitemcheckbox");
                    menuItem.element.onclick = (function (e) {
                        menuItem.toggled = itemCallback(e);
                        e.stopImmediatePropagation();
                    });
                    menuItem.element.onkeydown = function (e) {
                        if (e.keyCode === Common.KeyCodes.ENTER || e.keyCode === Common.KeyCodes.SPACE) {
                            menuItem.toggled = itemCallback(e);
                            e.stopImmediatePropagation();
                        }
                        else if (e.keyCode === Common.KeyCodes.ARROW_UP) {
                            if (menuItem.element.previousElementSibling) {
                                menuItem.element.previousElementSibling.focus();
                            }
                            e.stopImmediatePropagation();
                        }
                        else if (e.keyCode === Common.KeyCodes.ARROW_DOWN) {
                            if (menuItem.element.nextElementSibling) {
                                menuItem.element.nextElementSibling.focus();
                            }
                            e.stopImmediatePropagation();
                        }
                    };
                    this._target.disabled = false;
                };
                MenuControl.totalOffsetLeft = function (elem) {
                    var offsetLeft = 0;
                    do {
                        if (!isNaN(elem.offsetLeft)) {
                            offsetLeft += elem.offsetLeft;
                        }
                    } while (elem = elem.offsetParent);
                    return offsetLeft;
                };
                MenuControl.totalOffsetTop = function (elem) {
                    var offsetTop = 0;
                    do {
                        if (!isNaN(elem.offsetTop)) {
                            offsetTop += elem.offsetTop;
                        }
                    } while (elem = elem.offsetParent);
                    return offsetTop;
                };
                MenuControl.prototype.showMenu = function (e) {
                    var _this = this;
                    if (!this._isVisible) {
                        this._listElement.style.display = "block";
                        this._listElement.setAttribute("aria-hidden", "false");
                        this.setMenuPosition();
                        this._target.classList.add("menuControlActive");
                        window.setImmediate(function () {
                            document.body.addEventListener("click", _this._closeMenuFunction);
                            window.addEventListener("resize", _this._closeMenuFunction);
                        });
                        this._isVisible = true;
                    }
                };
                MenuControl.prototype.closeMenu = function () {
                    if (this._isVisible) {
                        this._listElement.style.display = "none";
                        this._listElement.setAttribute("aria-hidden", "true");
                        this._target.classList.remove("menuControlActive");
                        document.body.removeEventListener("click", this._closeMenuFunction);
                        window.removeEventListener("resize", this._closeMenuFunction);
                        this._isVisible = false;
                    }
                };
                MenuControl.prototype.setMenuPosition = function () {
                    this._listElement.style.left = "0px";
                    this._listElement.style.top = "0px";
                    // Get the coordinates of target based on the document
                    var targetTotalOffsetLeft = MenuControl.totalOffsetLeft(this._target);
                    var targetTotalOffsetTop = MenuControl.totalOffsetTop(this._target);
                    // Gets the offset position when listElement is at 0,0 to adjust later on this value.
                    // because 0,0 doesn't necessarly land on document 0,0 if there is a parent with absolute position.
                    var listElementZeroOffsetLeft = MenuControl.totalOffsetLeft(this._listElement);
                    var listElementZeroOffsetTop = MenuControl.totalOffsetTop(this._listElement);
                    // Calculate the left position 
                    var left = targetTotalOffsetLeft;
                    var right = left + this._listElement.offsetWidth;
                    if (right > window.innerWidth) {
                        var newRight = targetTotalOffsetLeft + this._target.offsetWidth;
                        var newLeft = newRight - this._listElement.offsetWidth;
                        if (newLeft >= 0) {
                            left = newLeft;
                            right = newRight;
                        }
                    }
                    this._listElement.style.left = left - listElementZeroOffsetLeft + "px";
                    // Calculate the top position
                    var top = targetTotalOffsetTop + this._target.offsetHeight;
                    var bottom = top + this._listElement.offsetHeight;
                    if (bottom > window.innerHeight) {
                        var newBottom = targetTotalOffsetTop;
                        var newTop = bottom - this._listElement.offsetHeight;
                        if (newTop >= 0) {
                            top = newTop;
                            bottom = newBottom;
                        }
                    }
                    this._listElement.style.top = top - listElementZeroOffsetTop + "px";
                };
                return MenuControl;
            }(Controls.TemplateControl));
            Controls.MenuControl = MenuControl;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="../Util/keyCodes.ts" />
/// <reference path="Control.ts" />
/// <reference path="contentControl.ts" />
/// <reference path="tabControl.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            "use strict";
            var TabItem = (function (_super) {
                __extends(TabItem, _super);
                function TabItem() {
                    _super.call(this);
                    var elem = document.createElement("li");
                    elem.setAttribute("role", "tab");
                    elem.setAttribute("aria-selected", "false");
                    this.header = new Controls.Control(elem);
                    this.header.rootElement.onclick = this.onHeaderClicked.bind(this);
                    this.header.rootElement.setAttribute("tabindex", "2");
                    this.header.rootElement.addEventListener("keydown", this.onKeyDown.bind(this));
                    this.rootElement.className = "tabItemContent";
                }
                Object.defineProperty(TabItem.prototype, "ownerTabControl", {
                    get: function () { return this._ownerTabControl; },
                    set: function (v) {
                        if (this._ownerTabControl !== v) {
                            if (this._ownerTabControl && v) {
                                throw new Error(Microsoft.Plugin.Resources.getErrorString("MemProf.1022"));
                            }
                            this._ownerTabControl = v;
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(TabItem.prototype, "active", {
                    get: function () { return this._active; },
                    set: function (v) {
                        if (this._active !== v) {
                            this._active = v;
                            this.header.rootElement.classList.toggle("active");
                            this.rootElement.classList.toggle("active");
                            this.header.rootElement.setAttribute("aria-selected", this._active ? "true" : "false");
                            this.onActiveChanged();
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(TabItem.prototype, "title", {
                    get: function () { return this.header.rootElement.innerText; },
                    set: function (v) {
                        this.header.rootElement.innerText = v;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(TabItem.prototype, "tooltipString", {
                    get: function () { return this.header.rootElement.getAttribute("data-plugin-vs-tooltip"); },
                    set: function (v) {
                        var tooltip = { content: v };
                        this.header.rootElement.setAttribute("data-plugin-vs-tooltip", JSON.stringify(tooltip));
                    },
                    enumerable: true,
                    configurable: true
                });
                /* overridable */
                TabItem.prototype.onActiveChanged = function () {
                };
                TabItem.prototype.onHeaderClicked = function () {
                    if (this.ownerTabControl) {
                        this.ownerTabControl.selectedItem = this;
                    }
                    // MemoryProfilerViewHost.onIdle();
                };
                TabItem.prototype.onKeyDown = function (e) {
                    if (e.keyCode === Common.KeyCodes.ENTER || e.keyCode === Common.KeyCodes.SPACE) {
                        this.onHeaderClicked();
                    }
                };
                return TabItem;
            }(Controls.ContentControl));
            Controls.TabItem = TabItem;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
/// <reference path="control.ts" />
/// <reference path="templateControl.ts" />
/// <reference path="tabItem.ts" />
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            "use strict";
            var TabControl = (function (_super) {
                __extends(TabControl, _super);
                function TabControl() {
                    _super.call(this);
                    this._items = [];
                    this.setTemplateFromHTML('<div class="tabControl">' +
                        '   <div class="tabHeader">' +
                        '       <div id="beforeBarContainer" class="beforeBarContainer"></div>' +
                        '       <nav id="tabBarContainer" class="tabBarContainer">' +
                        '        <ul class="tabBar" role="tablist"></ul>' +
                        '       </nav>' +
                        '       <div id="afterBarContainer" class="afterBarContainer"></div>' +
                        '   </div>' +
                        '   <div class="tabContentPane"></div>' +
                        '</div>');
                    this._barPanel = new Controls.Control(this.rootElement.getElementsByClassName("tabBar")[0]);
                    this._contentPane = new Controls.Control(this.rootElement.getElementsByClassName("tabContentPane")[0]);
                    this.beforeBarContainer = new Controls.Control(this.rootElement.getElementsByClassName("beforeBarContainer")[0]);
                    this.afterBarContainer = new Controls.Control(this.rootElement.getElementsByClassName("afterBarContainer")[0]);
                    this._tabBarContainer = this.findElement("tabBarContainer");
                }
                Object.defineProperty(TabControl.prototype, "tabsLeftAligned", {
                    get: function () {
                        return this._tabBarContainer.classList.contains("tabBarContainerLeftAlign");
                    },
                    set: function (v) {
                        if (v) {
                            this._tabBarContainer.classList.add("tabBarContainerLeftAlign");
                        }
                        else {
                            this._tabBarContainer.classList.remove("tabBarContainerLeftAlign");
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                TabControl.prototype.addTab = function (tabItem) {
                    this._items.push(tabItem);
                    tabItem.ownerTabControl = this;
                    this._barPanel.appendChild(tabItem.header);
                    this._contentPane.appendChild(tabItem);
                    if (!this._selectedItem) {
                        this.selectedItem = tabItem;
                    }
                };
                TabControl.prototype.removeTab = function (tabItem) {
                    var indexOfItem = this._items.indexOf(tabItem);
                    if (indexOfItem < 0) {
                        return;
                    }
                    if (this.selectedItem === tabItem) {
                        this.selectedItem = null;
                    }
                    this._items.splice(indexOfItem, 1);
                    var newSelectedItemIndex = Math.min(this._items.length - 1, indexOfItem);
                    if (newSelectedItemIndex >= 0) {
                        this.selectedItem = this._items[newSelectedItemIndex];
                    }
                    this._barPanel.removeChild(tabItem.header);
                    this._contentPane.removeChild(tabItem);
                    tabItem.ownerTabControl = null;
                };
                TabControl.prototype.containsTab = function (tabItem) {
                    return this._items.indexOf(tabItem) >= 0;
                };
                TabControl.prototype.getTab = function (index) {
                    return this._items[index];
                };
                TabControl.prototype.length = function () {
                    return this._items.length;
                };
                Object.defineProperty(TabControl.prototype, "selectedItem", {
                    get: function () { return this._selectedItem; },
                    set: function (tabItem) {
                        if (this._selectedItem !== tabItem) {
                            if (!this.containsTab(tabItem)) {
                                return;
                            }
                            if (this._selectedItem) {
                                this._selectedItem.active = false;
                            }
                            this._selectedItem = tabItem;
                            if (this._selectedItem) {
                                this._selectedItem.active = true;
                            }
                            if (this.selectedItemChanged) {
                                this.selectedItemChanged();
                            }
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                TabControl.prototype.onTabItemSelected = function (item) {
                    this.selectedItem = item;
                };
                return TabControl;
            }(Controls.TemplateControl));
            Controls.TabControl = TabControl;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
///<reference path="TemplateControl.ts"/>
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        var Controls;
        (function (Controls) {
            var View = (function (_super) {
                __extends(View, _super);
                function View(containerId) {
                    _super.call(this, containerId);
                }
                /*overridable*/
                View.prototype.render = function () {
                };
                /*overridable*/
                View.prototype.onResize = function () {
                };
                return View;
            }(Controls.TemplateControl));
            Controls.View = View;
        })(Controls = Common.Controls || (Common.Controls = {}));
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
var VsGraphics;
(function (VsGraphics) {
    var Constants = (function () {
        function Constants() {
        }
        Constants.MinGranularitySupportedInNs = 1;
        Constants.MEMORY_ANALYZER_CLASS_ID = "B821D548-5BA4-4C0E-8D23-CD46CE0C8E23";
        return Constants;
    }());
    VsGraphics.Constants = Constants;
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        "use strict";
        var Publisher = (function () {
            function Publisher(events) {
                /// <summary>
                ///     constructor
                /// </summary>
                /// <param name="events">List of supported events.</param>
                /// <summary>
                /// Event publisher.
                /// </summary>
                /// <summary>
                /// List of supported events.
                /// </summary>
                this._events = {};
                /// <summary>
                /// List of all registered events.
                /// </summary>
                this._listeners = {};
                if (events && events.length > 0) {
                    for (var i = 0; i < events.length; i++) {
                        var type = events[i];
                        if (type) {
                            this._events[type] = type;
                        }
                    }
                }
                else {
                    throw Error("Events are null or empty.");
                }
            }
            Publisher.prototype.addEventListener = function (eventType, func) {
                /// <summary>
                ///     Add event Listener
                /// </summary>
                /// <param name="eventType">Event type.</param>
                /// <param name="func">Callback function.</param>
                if (eventType && func) {
                    var type = this._events[eventType];
                    if (type) {
                        var callbacks = this._listeners[type] ? this._listeners[type] : this._listeners[type] = [];
                        callbacks.push(func);
                    }
                }
            };
            Publisher.prototype.removeEventListener = function (eventType, func) {
                /// <summary>
                ///     Remove event Listener
                /// </summary>
                /// <param name="eventType">Event type.</param>
                /// <param name="func">Callback function.</param>
                if (eventType && func) {
                    var callbacks = this._listeners[eventType];
                    if (callbacks) {
                        for (var i = 0; i < callbacks.length; i++) {
                            if (func === callbacks[i]) {
                                callbacks.splice(i, 1);
                                break;
                            }
                        }
                    }
                }
            };
            Publisher.prototype.invokeListener = function (args) {
                /// <summary>
                ///     Invoke event Listener
                /// </summary>
                /// <param name="args">Event argument.</param>
                if (args.type) {
                    var callbacks = this._listeners[args.type];
                    if (callbacks) {
                        for (var i = 0; i < callbacks.length; i++) {
                            var func = callbacks[i];
                            if (func) {
                                func(args);
                            }
                        }
                    }
                }
            };
            return Publisher;
        }());
        Common.Publisher = Publisher;
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
// 
// Copyright (C) Microsoft. All rights reserved.
//
var VsGraphics;
(function (VsGraphics) {
    var Common;
    (function (Common) {
        "use strict";
        var Utilities = (function () {
            function Utilities() {
            }
            Utilities.htmlEncode = function (value) {
                Utilities.HtmlEncodeDiv.innerText = value;
                return Utilities.HtmlEncodeDiv.innerHTML;
            };
            Utilities.HtmlEncodeDiv = document.createElement("div");
            return Utilities;
        }());
        Common.Utilities = Utilities;
    })(Common = VsGraphics.Common || (VsGraphics.Common = {}));
})(VsGraphics || (VsGraphics = {}));
//# sourceMappingURL=VsGraphics.js.map
// SIG // Begin signature block
// SIG // MIIkAgYJKoZIhvcNAQcCoIIj8zCCI+8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // tY+zrU7v1DqGamc373RKZZa7kQqpeW80OOncLSZn19+g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFccwghXDAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggbIwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIOyyduhMhB2rfF2CiWZAtVnqgJx+6T3UtMbt54lQ
// SIG // in7rMEYGCisGAQQBgjcCAQwxODA2oByAGgBWAHMARwBy
// SIG // AGEAcABoAGkAYwBzAC4AagBzoRaAFGh0dHA6Ly9taWNy
// SIG // b3NvZnQuY29tMA0GCSqGSIb3DQEBAQUABIIBAG2mBf9w
// SIG // WZUK0qOjFOsUkh/tAIg7MO0aDQoQ/K4xO3O/XavNlxwu
// SIG // 8kyKzv+EqJz71ZZxnViqIoJV5n7/jgvpEHol4zWevcY/
// SIG // Hx2z9d06hzvisnPQfa+U07wrxcWnHkNFg16pfxmgHDdp
// SIG // yrlgcpAMVgbk/ncHGVImkdhgYdX2Yk2/zmJbM8J7uI7I
// SIG // rFMi8GrW+ooUQsinbg3Y98vyh3oFZTPjzvb6o7v5ZXV/
// SIG // ffKLGX8XIQBtvN8VNPSdg09extwxC/vsdE1JtQgS41Jb
// SIG // 0Vq9PEaZTDqdWqeKoFlu0kz88IZ6r1xjCIF4LLU3fRa/
// SIG // 4XGtkCicYv3VewrWTdAa/ur6L2ChghNNMIITSQYKKwYB
// SIG // BAGCNwMDATGCEzkwghM1BgkqhkiG9w0BBwKgghMmMIIT
// SIG // IgIBAzEPMA0GCWCGSAFlAwQCAQUAMIIBPQYLKoZIhvcN
// SIG // AQkQAQSgggEsBIIBKDCCASQCAQEGCisGAQQBhFkKAwEw
// SIG // MTANBglghkgBZQMEAgEFAAQgAeRQ3nZsNckqwb4MWl8H
// SIG // DTaegtHzKI9AClktHp0UQhcCBliLsVazxRgTMjAxNzAy
// SIG // MDkwMzQ2MzEuODY5WjAHAgEBgAIB9KCBuaSBtjCBszEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEn
// SIG // MCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjMxQzUtMzBC
// SIG // QS03QzkxMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBTZXJ2aWNloIIO0DCCBnEwggRZoAMCAQICCmEJ
// SIG // gSoAAAAAAAIwDQYJKoZIhvcNAQELBQAwgYgxCzAJBgNV
// SIG // BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
// SIG // VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQg
// SIG // Q29ycG9yYXRpb24xMjAwBgNVBAMTKU1pY3Jvc29mdCBS
// SIG // b290IENlcnRpZmljYXRlIEF1dGhvcml0eSAyMDEwMB4X
// SIG // DTEwMDcwMTIxMzY1NVoXDTI1MDcwMTIxNDY1NVowfDEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwggEiMA0GCSqG
// SIG // SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCpHQ28dxGKOiDs
// SIG // /BOX9fp/aZRrdFQQ1aUKAIKF++18aEssX8XD5WHCdrc+
// SIG // Zitb8BVTJwQxH0EbGpUdzgkTjnxhMFmxMEQP8WCIhFRD
// SIG // DNdNuDgIs0Ldk6zWczBXJoKjRQ3Q6vVHgc2/JGAyWGBG
// SIG // 8lhHhjKEHnRhZ5FfgVSxz5NMksHEpl3RYRNuKMYa+YaA
// SIG // u99h/EbBJx0kZxJyGiGKr0tkiVBisV39dx898Fd1rL2K
// SIG // Qk1AUdEPnAY+Z3/1ZsADlkR+79BL/W7lmsqxqPJ6Kgox
// SIG // 8NpOBpG2iAg16HgcsOmZzTznL0S6p/TcZL2kAcEgCZN4
// SIG // zfy8wMlEXV4WnAEFTyJNAgMBAAGjggHmMIIB4jAQBgkr
// SIG // BgEEAYI3FQEEAwIBADAdBgNVHQ4EFgQU1WM6XIoxkPND
// SIG // e3xGG8UzaFqFbVUwGQYJKwYBBAGCNxQCBAweCgBTAHUA
// SIG // YgBDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMB
// SIG // Af8wHwYDVR0jBBgwFoAU1fZWy4/oolxiaNE9lJBb186a
// SIG // GMQwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWlj
// SIG // Um9vQ2VyQXV0XzIwMTAtMDYtMjMuY3JsMFoGCCsGAQUF
// SIG // BwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJB
// SIG // dXRfMjAxMC0wNi0yMy5jcnQwgaAGA1UdIAEB/wSBlTCB
// SIG // kjCBjwYJKwYBBAGCNy4DMIGBMD0GCCsGAQUFBwIBFjFo
// SIG // dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vUEtJL2RvY3Mv
// SIG // Q1BTL2RlZmF1bHQuaHRtMEAGCCsGAQUFBwICMDQeMiAd
// SIG // AEwAZQBnAGEAbABfAFAAbwBsAGkAYwB5AF8AUwB0AGEA
// SIG // dABlAG0AZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4IC
// SIG // AQAH5ohRDeLG4Jg/gXEDPZ2joSFvs+umzPUxvs8F4qn+
// SIG // +ldtGTCzwsVmyWrf9efweL3HqJ4l4/m87WtUVwgrUYJE
// SIG // Evu5U4zM9GASinbMQEBBm9xcF/9c+V4XNZgkVkt070IQ
// SIG // yK+/f8Z/8jd9Wj8c8pl5SpFSAK84Dxf1L3mBZdmptWvk
// SIG // x872ynoAb0swRCQiPM/tA6WWj1kpvLb9BOFwnzJKJ/1V
// SIG // ry/+tuWOM7tiX5rbV0Dp8c6ZZpCM/2pif93FSguRJuI5
// SIG // 7BlKcWOdeyFtw5yjojz6f32WapB4pm3S4Zz5Hfw42JT0
// SIG // xqUKloakvZ4argRCg7i1gJsiOCC1JeVk7Pf0v35jWSUP
// SIG // ei45V3aicaoGig+JFrphpxHLmtgOR5qAxdDNp9DvfYPw
// SIG // 4TtxCd9ddJgiCGHasFAeb73x4QDf5zEHpJM692VHeOj4
// SIG // qEir995yfmFrb3epgcunCaw5u+zGy9iCtHLNHfS4hQEe
// SIG // gPsbiSpUObJb2sgNVZl6h3M7COaYLeqN4DMuEin1wC9U
// SIG // JyH3yKxO2ii4sanblrKnQqLJzxlBTeCG+SqaoxFmMNO7
// SIG // dDJL32N79ZmKLxvHIa9Zta7cRDyXUHHXodLFVeNp3lfB
// SIG // 0d4wwP3M5k37Db9dT+mdHhk4L7zPWAUu7w2gUDXa7wkn
// SIG // HNWzfjUeCLraNtvTX4/edIhJEjCCBNowggPCoAMCAQIC
// SIG // EzMAAACgGph4PmbYqtcAAAAAAKAwDQYJKoZIhvcNAQEL
// SIG // BQAwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hp
// SIG // bmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoT
// SIG // FU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMd
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTAwHhcN
// SIG // MTYwOTA3MTc1NjQ4WhcNMTgwOTA3MTc1NjQ4WjCBszEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9QUjEn
// SIG // MCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjMxQzUtMzBC
// SIG // QS03QzkxMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1T
// SIG // dGFtcCBTZXJ2aWNlMIIBIjANBgkqhkiG9w0BAQEFAAOC
// SIG // AQ8AMIIBCgKCAQEA52wU4jDRZ9KtBK622yI96CopNe6h
// SIG // QakbU8w8PfgtvRENeMUEEQVrWEOU5GMkHWUj6cUz05Br
// SIG // FQ7RcEnqs+QiapTlbWMS5s9o1H1oNneIeM1ZtkbGvMhK
// SIG // OX/0a4QxOnGr9Ajeaxy3JO4fi1+H6HphTDlmr06jco1D
// SIG // DXWcuw5AqgsT5SzQdaXICnaH8d0V6T7ovybN4WpSGAKT
// SIG // d/0PEV6J8bYIXqNTJVK+lWVDAPS9O6o6tEtsBFJpKi2f
// SIG // zjh/Hjc/OoeQsR5jHlah2GDLv9jRWkR8cIoeU/onqawx
// SIG // pmsKnXysMJejJraEpcSl8bx1yMmM8BgRQeXPz9gYP00z
// SIG // BCOcGwIDAQABo4IBGzCCARcwHQYDVR0OBBYEFMiwxPeh
// SIG // FQIOYhdwOn5SNpFalHYBMB8GA1UdIwQYMBaAFNVjOlyK
// SIG // MZDzQ3t8RhvFM2hahW1VMFYGA1UdHwRPME0wS6BJoEeG
// SIG // RWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3Js
// SIG // L3Byb2R1Y3RzL01pY1RpbVN0YVBDQV8yMDEwLTA3LTAx
// SIG // LmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKG
// SIG // Pmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2Vy
// SIG // dHMvTWljVGltU3RhUENBXzIwMTAtMDctMDEuY3J0MAwG
// SIG // A1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwgw
// SIG // DQYJKoZIhvcNAQELBQADggEBABAJeQeXD5MucL1J1jbw
// SIG // VDnyQPaPP9IJdRzzWudobl061TgqE2sirzCtFR9B1MxT
// SIG // Rbn4v+coz1BfKzXm6h77818Q9ievvSB50lpsvkMITije
// SIG // +mTemKXeWyZNw2lJJztKPLCgwEyTfUadJoI8vC6Bfca1
// SIG // gjILJald4Grg2+Lhe6oiYssFtwY9bkW+8sGZfrAL0Cyu
// SIG // ggARt6snq64iDIQJM9B1ATsKsMuqIi/kBE2nrpD1ZHT4
// SIG // zFZsYS6+IVefhBdcu3KRrXngpCDrLgH0H9L/KQyb2vgm
// SIG // 4striVBVomm15MBYaaQoLn0AZfK9ScP6vzPGmUc+G2aJ
// SIG // zVZqqzvrZ7V9UlKhggN5MIICYQIBATCB46GBuaSBtjCB
// SIG // szELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjENMAsGA1UECxMETU9Q
// SIG // UjEnMCUGA1UECxMebkNpcGhlciBEU0UgRVNOOjMxQzUt
// SIG // MzBCQS03QzkxMSUwIwYDVQQDExxNaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBTZXJ2aWNloiUKAQEwCQYFKw4DAhoFAAMV
// SIG // AIQVUWUii4Xre1VA0VgDHA3Fcm/AoIHCMIG/pIG8MIG5
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BS
// SIG // MScwJQYDVQQLEx5uQ2lwaGVyIE5UUyBFU046NTdGNi1D
// SIG // MUUwLTU1NEMxKzApBgNVBAMTIk1pY3Jvc29mdCBUaW1l
// SIG // IFNvdXJjZSBNYXN0ZXIgQ2xvY2swDQYJKoZIhvcNAQEF
// SIG // BQACBQDcRjVdMCIYDzIwMTcwMjA5MDAyNTAxWhgPMjAx
// SIG // NzAyMTAwMDI1MDFaMHcwPQYKKwYBBAGEWQoEATEvMC0w
// SIG // CgIFANxGNV0CAQAwCgIBAAICDfkCAf8wBwIBAAICGT0w
// SIG // CgIFANxHht0CAQAwNgYKKwYBBAGEWQoEAjEoMCYwDAYK
// SIG // KwYBBAGEWQoDAaAKMAgCAQACAxbjYKEKMAgCAQACAweh
// SIG // IDANBgkqhkiG9w0BAQUFAAOCAQEAjGPh3VwWJyZ47Y+n
// SIG // YinLX4g/6Mty4I2RlSZu5ERU4SeRm8qpC9nbO/lkG7/x
// SIG // cPthwFPEcNJPLQDt/4lI9xGOF3bI1fMzL8EjX8AOYkIZ
// SIG // VVd84oi3sWPie+bvtLlcTmNnkcCPKvobbHdvpLqJ4Udu
// SIG // +1p0tYbtNQ/FDUSg7i0cMt3L/9Ut0FNOqB3+7A5SNdf0
// SIG // 21aonYZalB8QQnyB+HGS76X4XvKMD8AYVo/hsj6MZD3o
// SIG // nsXNXwvGufEfw0HtIQri8HnLykerhMFpkTRDgZKwvV7J
// SIG // DAvyIaohup1KLPkrFe7HqurWxwjrZuJ2QNYN8P8W62cx
// SIG // EOlvHFeMbTl7vWijYDGCAvUwggLxAgEBMIGTMHwxCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAoBqYeD5m
// SIG // 2KrXAAAAAACgMA0GCWCGSAFlAwQCAQUAoIIBMjAaBgkq
// SIG // hkiG9w0BCQMxDQYLKoZIhvcNAQkQAQQwLwYJKoZIhvcN
// SIG // AQkEMSIEIHkINsChX2KgS44FghfjIYYmO5OJvTU3jNCy
// SIG // LdIoMYoyMIHiBgsqhkiG9w0BCRACDDGB0jCBzzCBzDCB
// SIG // sQQUhBVRZSKLhet7VUDRWAMcDcVyb8AwgZgwgYCkfjB8
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMAITMwAAAKAa
// SIG // mHg+Ztiq1wAAAAAAoDAWBBSHAuOl9IFjEgSdOkWRBBcP
// SIG // 1L3qzjANBgkqhkiG9w0BAQsFAASCAQAz0kkLx1r3r56P
// SIG // BkKduawLs+uWDuvBegqBh2tDrH12aHbwIBbv6P4C/vNI
// SIG // Xdlq20Gm0DE5L+8LU9FJ8vTwLgbqbC20SyRDSZTI9CvZ
// SIG // MkWc2BzHp18dBy5CkAhQHnlAVdWJasaYFE5W7yG3uCGO
// SIG // SouKL+NptN4j44LWCpKVN+fLvnUqvG+dtliYPCPy68/2
// SIG // Za0agsl9hFC8fTZqp5PFxkGCYI4MSOPLvIb746s4H3s0
// SIG // TgbGJ72/jk0rIUA20icjFvNLAHDrgN2JfcctQrQr1JlV
// SIG // icERM9PpzydtOdy6IZlZdmEr8kdYnAML3wbxfNDf0qZj
// SIG // 5TTBwyxjuFvBXFisxy0j
// SIG // End signature block
